/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.virtdata.library.curves4.continuous.int_double;

import io.nosqlbench.virtdata.library.curves4.continuous.common.InterpolatingIntDoubleSampler;
import io.nosqlbench.virtdata.library.curves4.continuous.common.RealDistributionICDSource;
import io.nosqlbench.virtdata.library.curves4.continuous.common.RealIntDoubleSampler;
import java.util.Arrays;
import java.util.HashSet;
import java.util.function.IntToDoubleFunction;
import org.apache.commons.statistics.distribution.ContinuousDistribution;

public class IntToDoubleContinuousCurve
implements IntToDoubleFunction {
    private final ContinuousDistribution distribution;
    private final IntToDoubleFunction function;
    public static final String COMPUTE = "compute";
    public static final String INTERPOLATE = "interpolate";
    public static final String MAP = "map";
    public static final String HASH = "hash";
    public static final String CLAMP = "clamp";
    public static final String NOCLAMP = "noclamp";
    public static final String INFINITE = "infinite";
    public static final String FINITE = "finite";
    private static final HashSet<String> validModifiers = new HashSet<String>(){
        {
            this.add(IntToDoubleContinuousCurve.COMPUTE);
            this.add(IntToDoubleContinuousCurve.INTERPOLATE);
            this.add(IntToDoubleContinuousCurve.MAP);
            this.add(IntToDoubleContinuousCurve.HASH);
            this.add(IntToDoubleContinuousCurve.CLAMP);
            this.add(IntToDoubleContinuousCurve.NOCLAMP);
            this.add(IntToDoubleContinuousCurve.INFINITE);
            this.add(IntToDoubleContinuousCurve.FINITE);
        }
    };

    public IntToDoubleContinuousCurve(ContinuousDistribution distribution, String ... modslist) {
        this.distribution = distribution;
        HashSet<String> mods = new HashSet<String>(Arrays.asList(modslist));
        RealDistributionICDSource icdSource = new RealDistributionICDSource(distribution);
        if (mods.contains(HASH) && mods.contains(MAP)) {
            throw new RuntimeException("mods must not contain both hash and map.");
        }
        if (mods.contains(INTERPOLATE) && mods.contains(COMPUTE)) {
            throw new RuntimeException("mods must not contain both interpolate and compute.");
        }
        if (mods.contains(CLAMP) && mods.contains(NOCLAMP)) {
            throw new RuntimeException("mods must not contain both clamp and noclamp.");
        }
        if (mods.contains(INFINITE) && mods.contains(FINITE)) {
            throw new RuntimeException("mods must not contain both infinite and finite.");
        }
        for (String s : modslist) {
            if (validModifiers.contains(s)) continue;
            throw new RuntimeException("modifier '" + s + "' is not a valid modifier. Use one of " + validModifiers + " instead.");
        }
        boolean hash = mods.contains(HASH) || !mods.contains(MAP);
        boolean interpolate = mods.contains(INTERPOLATE) || !mods.contains(COMPUTE);
        boolean clamp = mods.contains(CLAMP) || !mods.contains(NOCLAMP);
        boolean finite = mods.contains(FINITE) || !mods.contains(INFINITE);
        this.function = interpolate ? new InterpolatingIntDoubleSampler(icdSource, 1000, hash, clamp, -2.147483648E9, 2.147483647E9, finite) : new RealIntDoubleSampler(icdSource, hash, clamp, -2.147483648E9, 2.147483647E9, true);
    }

    @Override
    public double applyAsDouble(int value) {
        return this.function.applyAsDouble(value);
    }
}

