/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.virtdata.library.curves4.continuous.long_double;

import io.nosqlbench.virtdata.api.annotations.Example;
import io.nosqlbench.virtdata.api.annotations.Examples;
import io.nosqlbench.virtdata.api.annotations.ThreadSafeMapper;
import io.nosqlbench.virtdata.library.curves4.continuous.long_double.LongToDoubleContinuousCurve;
import org.apache.commons.math4.distribution.EnumeratedRealDistribution;

@ThreadSafeMapper
public class Enumerated
extends LongToDoubleContinuousCurve {
    @Examples(value={@Example(value={"Enumerated('1 2 3 4 5 6')", "a fair 6-sided die"}), @Example(value={"Enumerated('1:2.0 2 3 4 5:0.5 6:0.5')", "an unfair fair 6-sided die, where ones are twice as likely, and fives and sixes are half as likely"})})
    public Enumerated(String data, String ... mods) {
        super(new EnumeratedRealDistribution(Enumerated.parseWeights(data)[0], Enumerated.parseWeights(data)[1]), mods);
    }

    private static double[][] parseWeights(String input) {
        String[] entries = input.split("[;, ]");
        double[][] elements = new double[2][entries.length];
        block4: for (int i = 0; i < entries.length; ++i) {
            String[] parts = entries[i].split(":");
            elements[1][i] = 1.0;
            switch (parts.length) {
                case 2: {
                    elements[1][i] = Double.parseDouble(parts[1]);
                }
                case 1: {
                    elements[0][i] = Double.parseDouble(parts[0]);
                    continue block4;
                }
                default: {
                    throw new RuntimeException("Unable to parse entry or weight from '" + entries[i] + "'");
                }
            }
        }
        return elements;
    }
}

