/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.virtdata.library.curves4.continuous.long_double;

import io.nosqlbench.virtdata.library.curves4.continuous.common.InterpolatingLongDoubleSampler;
import io.nosqlbench.virtdata.library.curves4.continuous.common.RealDistributionICDSource;
import io.nosqlbench.virtdata.library.curves4.continuous.common.RealLongDoubleSampler;
import java.util.Arrays;
import java.util.HashSet;
import java.util.function.LongToDoubleFunction;
import org.apache.commons.statistics.distribution.ContinuousDistribution;

public class LongToDoubleContinuousCurve
implements LongToDoubleFunction {
    private final ContinuousDistribution distribution;
    private final LongToDoubleFunction function;
    public static final String COMPUTE = "compute";
    public static final String INTERPOLATE = "interpolate";
    public static final String MAP = "map";
    public static final String HASH = "hash";
    public static final String CLAMP = "clamp";
    public static final String NOCLAMP = "noclamp";
    public static final String INFINITE = "infinite";
    public static final String FINITE = "finite";
    private static final HashSet<String> validModifiers = new HashSet<String>(){
        {
            this.add(LongToDoubleContinuousCurve.COMPUTE);
            this.add(LongToDoubleContinuousCurve.INTERPOLATE);
            this.add(LongToDoubleContinuousCurve.MAP);
            this.add(LongToDoubleContinuousCurve.HASH);
            this.add(LongToDoubleContinuousCurve.CLAMP);
            this.add(LongToDoubleContinuousCurve.NOCLAMP);
            this.add(LongToDoubleContinuousCurve.INFINITE);
            this.add(LongToDoubleContinuousCurve.FINITE);
        }
    };

    public LongToDoubleContinuousCurve(ContinuousDistribution distribution, String ... modslist) {
        this.distribution = distribution;
        HashSet<String> mods = new HashSet<String>(Arrays.asList(modslist));
        RealDistributionICDSource icdSource = new RealDistributionICDSource(distribution);
        if (mods.contains(HASH) && mods.contains(MAP)) {
            throw new RuntimeException("mods must not contain both hash and map.");
        }
        if (mods.contains(INTERPOLATE) && mods.contains(COMPUTE)) {
            throw new RuntimeException("mods must not contain both interpolate and compute.");
        }
        if (mods.contains(CLAMP) && mods.contains(NOCLAMP)) {
            throw new RuntimeException("mods must not contain both clamp and noclamp.");
        }
        if (mods.contains(INFINITE) && mods.contains(FINITE)) {
            throw new RuntimeException("mods must not contain both infinite and finite.");
        }
        for (String s : modslist) {
            if (validModifiers.contains(s)) continue;
            throw new RuntimeException("modifier '" + s + "' is not a valid modifier. Use one of " + validModifiers + " instead.");
        }
        boolean hash = mods.contains(HASH) || !mods.contains(MAP);
        boolean interpolate = mods.contains(INTERPOLATE) || !mods.contains(COMPUTE);
        boolean clamp = mods.contains(CLAMP) || !mods.contains(NOCLAMP);
        boolean finite = mods.contains(FINITE) || !mods.contains(INFINITE);
        this.function = interpolate ? new InterpolatingLongDoubleSampler(icdSource, 1000, hash, clamp, -9.223372036854776E18, 9.223372036854776E18, finite) : new RealLongDoubleSampler(icdSource, hash, clamp, -9.223372036854776E18, 9.223372036854776E18, true);
    }

    @Override
    public double applyAsDouble(long value) {
        return this.function.applyAsDouble(value);
    }
}

