/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.virtdata.library.curves4.discrete.common;

import io.nosqlbench.virtdata.library.curves4.discrete.common.ThreadSafeHash;
import java.util.function.DoubleToIntFunction;
import java.util.function.LongUnaryOperator;

public class InterpolatingLongLongSampler
implements LongUnaryOperator {
    private final double[] lut;
    private final DoubleToIntFunction f;
    private ThreadSafeHash hash;
    private final double scaleToLong;

    public InterpolatingLongLongSampler(DoubleToIntFunction icdSource, int resolution, boolean hash) {
        this.f = icdSource;
        if (hash) {
            this.hash = new ThreadSafeHash();
        }
        double[] computed = this.precompute(resolution);
        double[] padded = new double[computed.length + 1];
        System.arraycopy(computed, 0, padded, 0, computed.length);
        padded[padded.length - 1] = padded[padded.length - 2];
        this.scaleToLong = 1.0842021724855044E-19 * (double)(padded.length - 2);
        this.lut = padded;
    }

    private double[] precompute(int resolution) {
        double[] precomputed = new double[resolution];
        for (int s = 0; s < resolution; ++s) {
            double rangedToUnit = (double)s / (double)resolution;
            int sampleValue = this.f.applyAsInt(rangedToUnit);
            precomputed[s] = sampleValue;
        }
        return precomputed;
    }

    @Override
    public long applyAsLong(long input) {
        if (this.hash != null) {
            input = this.hash.applyAsLong(input);
        }
        double samplePoint = this.scaleToLong * (double)input;
        int leftidx = (int)samplePoint;
        double fractional = samplePoint - (double)leftidx;
        double sample = this.lut[leftidx] * (1.0 - fractional) + this.lut[leftidx + 1] * fractional;
        return (long)sample;
    }
}

