/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math4.random;

import org.apache.commons.math4.random.NormalizedRandomGenerator;
import org.apache.commons.math4.util.FastMath;
import org.apache.commons.rng.UniformRandomProvider;

public class UniformRandomGenerator
implements NormalizedRandomGenerator {
    private static final double SQRT3 = FastMath.sqrt(3.0);
    private final UniformRandomProvider generator;

    public UniformRandomGenerator(UniformRandomProvider generator) {
        this.generator = generator;
    }

    @Override
    public double nextNormalizedDouble() {
        return SQRT3 * (2.0 * this.generator.nextDouble() - 1.0);
    }
}

