/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math4.util;

import java.io.Serializable;
import java.util.Arrays;
import org.apache.commons.math4.exception.MathIllegalArgumentException;
import org.apache.commons.math4.exception.MathIllegalStateException;
import org.apache.commons.math4.exception.NotStrictlyPositiveException;
import org.apache.commons.math4.exception.NullArgumentException;
import org.apache.commons.math4.exception.NumberIsTooSmallException;
import org.apache.commons.math4.exception.util.Localizable;
import org.apache.commons.math4.exception.util.LocalizedFormats;
import org.apache.commons.math4.util.DoubleArray;
import org.apache.commons.math4.util.FastMath;
import org.apache.commons.math4.util.MathArrays;
import org.apache.commons.math4.util.MathUtils;

public class ResizableDoubleArray
implements DoubleArray,
Serializable {
    private static final long serialVersionUID = -3485529955529426875L;
    private static final int DEFAULT_INITIAL_CAPACITY = 16;
    private static final double DEFAULT_EXPANSION_FACTOR = 2.0;
    private static final ExpansionMode DEFAULT_EXPANSION_MODE = ExpansionMode.MULTIPLICATIVE;
    private static final double DEFAULT_CONTRACTION_DELTA = 0.5;
    private final double contractionCriterion;
    private final double expansionFactor;
    private final ExpansionMode expansionMode;
    private double[] internalArray;
    private int numElements = 0;
    private int startIndex = 0;

    public ResizableDoubleArray() {
        this(16);
    }

    public ResizableDoubleArray(int initialCapacity) throws MathIllegalArgumentException {
        this(initialCapacity, 2.0);
    }

    public ResizableDoubleArray(double[] initialArray) {
        this(initialArray == null || initialArray.length == 0 ? 16 : initialArray.length, 2.0, 2.5, DEFAULT_EXPANSION_MODE, initialArray);
    }

    public ResizableDoubleArray(int initialCapacity, double expansionFactor) throws MathIllegalArgumentException {
        this(initialCapacity, expansionFactor, 0.5 + expansionFactor);
    }

    public ResizableDoubleArray(int initialCapacity, double expansionFactor, double contractionCriterion) throws MathIllegalArgumentException {
        this(initialCapacity, expansionFactor, contractionCriterion, DEFAULT_EXPANSION_MODE, null);
    }

    public ResizableDoubleArray(int initialCapacity, double expansionFactor, double contractionCriterion, ExpansionMode expansionMode, double ... data) throws MathIllegalArgumentException {
        if (initialCapacity <= 0) {
            throw new NotStrictlyPositiveException((Localizable)LocalizedFormats.INITIAL_CAPACITY_NOT_POSITIVE, initialCapacity);
        }
        this.checkContractExpand(contractionCriterion, expansionFactor);
        MathUtils.checkNotNull((Object)expansionMode);
        this.expansionFactor = expansionFactor;
        this.contractionCriterion = contractionCriterion;
        this.expansionMode = expansionMode;
        this.internalArray = new double[initialCapacity];
        this.numElements = 0;
        this.startIndex = 0;
        if (data != null && data.length > 0) {
            this.addElements(data);
        }
    }

    public ResizableDoubleArray(ResizableDoubleArray original) throws NullArgumentException {
        MathUtils.checkNotNull(original);
        this.contractionCriterion = original.contractionCriterion;
        this.expansionFactor = original.expansionFactor;
        this.expansionMode = original.expansionMode;
        this.internalArray = new double[original.internalArray.length];
        System.arraycopy(original.internalArray, 0, this.internalArray, 0, this.internalArray.length);
        this.numElements = original.numElements;
        this.startIndex = original.startIndex;
    }

    @Override
    public void addElement(double value) {
        if (this.internalArray.length <= this.startIndex + this.numElements) {
            this.expand();
        }
        this.internalArray[this.startIndex + this.numElements++] = value;
    }

    @Override
    public void addElements(double[] values) {
        double[] tempArray = new double[this.numElements + values.length + 1];
        System.arraycopy(this.internalArray, this.startIndex, tempArray, 0, this.numElements);
        System.arraycopy(values, 0, tempArray, this.numElements, values.length);
        this.internalArray = tempArray;
        this.startIndex = 0;
        this.numElements += values.length;
    }

    @Override
    public double addElementRolling(double value) {
        double discarded = this.internalArray[this.startIndex];
        if (this.startIndex + (this.numElements + 1) > this.internalArray.length) {
            this.expand();
        }
        ++this.startIndex;
        this.internalArray[this.startIndex + (this.numElements - 1)] = value;
        if (this.shouldContract()) {
            this.contract();
        }
        return discarded;
    }

    public double substituteMostRecentElement(double value) throws MathIllegalStateException {
        if (this.numElements < 1) {
            throw new MathIllegalStateException(LocalizedFormats.CANNOT_SUBSTITUTE_ELEMENT_FROM_EMPTY_ARRAY, new Object[0]);
        }
        int substIndex = this.startIndex + (this.numElements - 1);
        double discarded = this.internalArray[substIndex];
        this.internalArray[substIndex] = value;
        return discarded;
    }

    protected void checkContractExpand(double contraction, double expansion) throws NumberIsTooSmallException {
        if (contraction < expansion) {
            NumberIsTooSmallException e = new NumberIsTooSmallException(contraction, (Number)1, true);
            e.getContext().addMessage(LocalizedFormats.CONTRACTION_CRITERIA_SMALLER_THAN_EXPANSION_FACTOR, contraction, expansion);
            throw e;
        }
        if (contraction <= 1.0) {
            NumberIsTooSmallException e = new NumberIsTooSmallException(contraction, (Number)1, false);
            e.getContext().addMessage(LocalizedFormats.CONTRACTION_CRITERIA_SMALLER_THAN_ONE, contraction);
            throw e;
        }
        if (expansion <= 1.0) {
            NumberIsTooSmallException e = new NumberIsTooSmallException(contraction, (Number)1, false);
            e.getContext().addMessage(LocalizedFormats.EXPANSION_FACTOR_SMALLER_THAN_ONE, expansion);
            throw e;
        }
    }

    @Override
    public void clear() {
        this.numElements = 0;
        this.startIndex = 0;
    }

    public void contract() {
        double[] tempArray = new double[this.numElements + 1];
        System.arraycopy(this.internalArray, this.startIndex, tempArray, 0, this.numElements);
        this.internalArray = tempArray;
        this.startIndex = 0;
    }

    public void discardFrontElements(int i) throws MathIllegalArgumentException {
        this.discardExtremeElements(i, true);
    }

    public void discardMostRecentElements(int i) throws MathIllegalArgumentException {
        this.discardExtremeElements(i, false);
    }

    private void discardExtremeElements(int i, boolean front) throws MathIllegalArgumentException {
        if (i > this.numElements) {
            throw new MathIllegalArgumentException(LocalizedFormats.TOO_MANY_ELEMENTS_TO_DISCARD_FROM_ARRAY, i, this.numElements);
        }
        if (i < 0) {
            throw new MathIllegalArgumentException(LocalizedFormats.CANNOT_DISCARD_NEGATIVE_NUMBER_OF_ELEMENTS, i);
        }
        this.numElements -= i;
        if (front) {
            this.startIndex += i;
        }
        if (this.shouldContract()) {
            this.contract();
        }
    }

    protected void expand() {
        int newSize = 0;
        newSize = this.expansionMode == ExpansionMode.MULTIPLICATIVE ? (int)FastMath.ceil((double)this.internalArray.length * this.expansionFactor) : (int)((long)this.internalArray.length + FastMath.round(this.expansionFactor));
        double[] tempArray = new double[newSize];
        System.arraycopy(this.internalArray, 0, tempArray, 0, this.internalArray.length);
        this.internalArray = tempArray;
    }

    private void expandTo(int size) {
        double[] tempArray = new double[size];
        System.arraycopy(this.internalArray, 0, tempArray, 0, this.internalArray.length);
        this.internalArray = tempArray;
    }

    public double getContractionCriterion() {
        return this.contractionCriterion;
    }

    @Override
    public double getElement(int index) {
        if (index >= this.numElements) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        if (index >= 0) {
            return this.internalArray[this.startIndex + index];
        }
        throw new ArrayIndexOutOfBoundsException(index);
    }

    @Override
    public double[] getElements() {
        double[] elementArray = new double[this.numElements];
        System.arraycopy(this.internalArray, this.startIndex, elementArray, 0, this.numElements);
        return elementArray;
    }

    public double getExpansionFactor() {
        return this.expansionFactor;
    }

    public ExpansionMode getExpansionMode() {
        return this.expansionMode;
    }

    public int getCapacity() {
        return this.internalArray.length;
    }

    @Override
    public int getNumElements() {
        return this.numElements;
    }

    protected double[] getArrayRef() {
        return this.internalArray;
    }

    protected int getStartIndex() {
        return this.startIndex;
    }

    public double compute(MathArrays.Function f) {
        return f.evaluate(this.internalArray, this.startIndex, this.numElements);
    }

    @Override
    public void setElement(int index, double value) {
        if (index < 0) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        if (index + 1 > this.numElements) {
            this.numElements = index + 1;
        }
        if (this.startIndex + index >= this.internalArray.length) {
            this.expandTo(this.startIndex + (index + 1));
        }
        this.internalArray[this.startIndex + index] = value;
    }

    public void setNumElements(int i) throws MathIllegalArgumentException {
        if (i < 0) {
            throw new MathIllegalArgumentException(LocalizedFormats.INDEX_NOT_POSITIVE, i);
        }
        int newSize = this.startIndex + i;
        if (newSize > this.internalArray.length) {
            this.expandTo(newSize);
        }
        this.numElements = i;
    }

    private boolean shouldContract() {
        if (this.expansionMode == ExpansionMode.MULTIPLICATIVE) {
            return (double)((float)this.internalArray.length / (float)this.numElements) > this.contractionCriterion;
        }
        return (double)(this.internalArray.length - this.numElements) > this.contractionCriterion;
    }

    public ResizableDoubleArray copy() {
        return new ResizableDoubleArray(this);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof ResizableDoubleArray)) {
            return false;
        }
        boolean result = true;
        ResizableDoubleArray other = (ResizableDoubleArray)object;
        result = result && other.contractionCriterion == this.contractionCriterion;
        result = result && other.expansionFactor == this.expansionFactor;
        result = result && other.expansionMode == this.expansionMode;
        result = result && other.numElements == this.numElements;
        boolean bl = result = result && other.startIndex == this.startIndex;
        if (!result) {
            return false;
        }
        return Arrays.equals(this.internalArray, other.internalArray);
    }

    public int hashCode() {
        int[] hashData = new int[]{Double.valueOf(this.expansionFactor).hashCode(), Double.valueOf(this.contractionCriterion).hashCode(), this.expansionMode.hashCode(), Arrays.hashCode(this.internalArray), this.numElements, this.startIndex};
        return Arrays.hashCode(hashData);
    }

    public static enum ExpansionMode {
        MULTIPLICATIVE,
        ADDITIVE;

    }
}

