/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.numbers.gamma;

import org.apache.commons.numbers.gamma.InvGamma1pm1;
import org.apache.commons.numbers.gamma.LanczosApproximation;

public class Gamma {
    private static final double SQRT_TWO_PI = 2.5066282746310007;

    public static double value(double x) {
        if (x == Math.rint(x) && x <= 0.0) {
            return Double.NaN;
        }
        double absX = Math.abs(x);
        if (absX <= 20.0) {
            if (x >= 1.0) {
                double prod = 1.0;
                double t = x;
                while (t > 2.5) {
                    prod *= (t -= 1.0);
                }
                return prod / (1.0 + InvGamma1pm1.value(t - 1.0));
            }
            double prod = x;
            double t = x;
            while (t < -0.5) {
                prod *= (t += 1.0);
            }
            return 1.0 / (prod * (1.0 + InvGamma1pm1.value(t)));
        }
        double y = absX + LanczosApproximation.g() + 0.5;
        double gammaAbs = 2.5066282746310007 / absX * Math.pow(y, absX + 0.5) * Math.exp(-y) * LanczosApproximation.value(absX);
        if (x > 0.0) {
            return gammaAbs;
        }
        return -Math.PI / (x * Math.sin(Math.PI * x) * gammaAbs);
    }
}

