/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.rng.core.source32;

import org.apache.commons.rng.core.source32.IntProvider;
import org.apache.commons.rng.core.util.NumberFactory;

abstract class AbstractXoRoShiRo64
extends IntProvider {
    private static final int SEED_SIZE = 2;
    protected int state0;
    protected int state1;

    AbstractXoRoShiRo64(int[] seed) {
        if (seed.length < 2) {
            int[] state = new int[2];
            this.fillState(state, seed);
            this.setState(state);
        } else {
            this.setState(seed);
        }
    }

    AbstractXoRoShiRo64(int seed0, int seed1) {
        this.state0 = seed0;
        this.state1 = seed1;
    }

    private void setState(int[] state) {
        this.state0 = state[0];
        this.state1 = state[1];
    }

    @Override
    protected byte[] getStateInternal() {
        return this.composeStateInternal(NumberFactory.makeByteArray(new int[]{this.state0, this.state1}), super.getStateInternal());
    }

    @Override
    protected void setStateInternal(byte[] s) {
        byte[][] c = this.splitStateInternal(s, 8);
        this.setState(NumberFactory.makeIntArray(c[0]));
        super.setStateInternal(c[1]);
    }
}

