/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.rng.core.source32;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Random;
import org.apache.commons.rng.core.source32.IntProvider;

public class JDKRandom
extends IntProvider {
    private Random delegate;
    private int stateSize;

    public JDKRandom(Long seed) {
        this.delegate = new Random(seed);
    }

    @Override
    public int next() {
        return this.delegate.nextInt();
    }

    @Override
    protected byte[] getStateInternal() {
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(bos);
            oos.writeObject(this.delegate);
            byte[] state = bos.toByteArray();
            this.stateSize = state.length;
            return this.composeStateInternal(state, super.getStateInternal());
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    protected void setStateInternal(byte[] s) {
        byte[][] c = this.splitStateInternal(s, this.stateSize);
        try {
            ByteArrayInputStream bis = new ByteArrayInputStream(c[0]);
            ObjectInputStream ois = new ObjectInputStream(bis);
            this.delegate = (Random)ois.readObject();
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException(e);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        super.setStateInternal(c[1]);
    }
}

