/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.rng.core.source64;

import org.apache.commons.rng.core.source64.LongProvider;
import org.apache.commons.rng.core.util.NumberFactory;

abstract class AbstractXoRoShiRo128
extends LongProvider {
    private static final int SEED_SIZE = 2;
    protected long state0;
    protected long state1;

    AbstractXoRoShiRo128(long[] seed) {
        if (seed.length < 2) {
            long[] state = new long[2];
            this.fillState(state, seed);
            this.setState(state);
        } else {
            this.setState(seed);
        }
    }

    AbstractXoRoShiRo128(long seed0, long seed1) {
        this.state0 = seed0;
        this.state1 = seed1;
    }

    private void setState(long[] state) {
        this.state0 = state[0];
        this.state1 = state[1];
    }

    @Override
    protected byte[] getStateInternal() {
        return this.composeStateInternal(NumberFactory.makeByteArray(new long[]{this.state0, this.state1}), super.getStateInternal());
    }

    @Override
    protected void setStateInternal(byte[] s) {
        byte[][] c = this.splitStateInternal(s, 16);
        this.setState(NumberFactory.makeLongArray(c[0]));
        super.setStateInternal(c[1]);
    }
}

