/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.rng.core.source64;

import org.apache.commons.rng.core.source64.LongProvider;
import org.apache.commons.rng.core.util.NumberFactory;

abstract class AbstractXoShiRo512
extends LongProvider {
    private static final int SEED_SIZE = 8;
    protected long state0;
    protected long state1;
    protected long state2;
    protected long state3;
    protected long state4;
    protected long state5;
    protected long state6;
    protected long state7;

    AbstractXoShiRo512(long[] seed) {
        if (seed.length < 8) {
            long[] state = new long[8];
            this.fillState(state, seed);
            this.setState(state);
        } else {
            this.setState(seed);
        }
    }

    AbstractXoShiRo512(long seed0, long seed1, long seed2, long seed3, long seed4, long seed5, long seed6, long seed7) {
        this.state0 = seed0;
        this.state1 = seed1;
        this.state2 = seed2;
        this.state3 = seed3;
        this.state4 = seed4;
        this.state5 = seed5;
        this.state6 = seed6;
        this.state7 = seed7;
    }

    private void setState(long[] state) {
        this.state0 = state[0];
        this.state1 = state[1];
        this.state2 = state[2];
        this.state3 = state[3];
        this.state4 = state[4];
        this.state5 = state[5];
        this.state6 = state[6];
        this.state7 = state[7];
    }

    @Override
    protected byte[] getStateInternal() {
        return this.composeStateInternal(NumberFactory.makeByteArray(new long[]{this.state0, this.state1, this.state2, this.state3, this.state4, this.state5, this.state6, this.state7}), super.getStateInternal());
    }

    @Override
    protected void setStateInternal(byte[] s) {
        byte[][] c = this.splitStateInternal(s, 64);
        this.setState(NumberFactory.makeLongArray(c[0]));
        super.setStateInternal(c[1]);
    }
}

