/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.rng.core.source64;

import java.util.Arrays;
import org.apache.commons.rng.core.source64.LongProvider;
import org.apache.commons.rng.core.util.NumberFactory;

public class MersenneTwister64
extends LongProvider {
    private static final int NN = 312;
    private static final int MM = 156;
    private static final long[] MAG01 = new long[]{0L, -5403634167711393303L};
    private static final long UM = Integer.MIN_VALUE;
    private static final long LM = Integer.MAX_VALUE;
    private long[] mt = new long[312];
    private int mti;

    public MersenneTwister64(long[] seed) {
        this.setSeedInternal(seed);
    }

    @Override
    protected byte[] getStateInternal() {
        long[] s = Arrays.copyOf(this.mt, 313);
        s[312] = this.mti;
        return this.composeStateInternal(NumberFactory.makeByteArray(s), super.getStateInternal());
    }

    @Override
    protected void setStateInternal(byte[] s) {
        byte[][] c = this.splitStateInternal(s, 2504);
        long[] tmp = NumberFactory.makeLongArray(c[0]);
        System.arraycopy(tmp, 0, this.mt, 0, 312);
        this.mti = (int)tmp[312];
        super.setStateInternal(c[1]);
    }

    private void setSeedInternal(long[] seed) {
        long mm1;
        int k;
        if (seed.length == 0) {
            seed = new long[1];
        }
        this.initState(19650218L);
        int i = 1;
        int j = 0;
        for (k = Math.max(312, seed.length); k != 0; --k) {
            mm1 = this.mt[i - 1];
            this.mt[i] = (this.mt[i] ^ (mm1 ^ mm1 >>> 62) * 3935559000370003845L) + seed[j] + (long)j;
            ++j;
            if (++i >= 312) {
                this.mt[0] = this.mt[311];
                i = 1;
            }
            if (j < seed.length) continue;
            j = 0;
        }
        for (k = 311; k != 0; --k) {
            mm1 = this.mt[i - 1];
            this.mt[i] = (this.mt[i] ^ (mm1 ^ mm1 >>> 62) * 2862933555777941757L) - (long)i;
            if (++i < 312) continue;
            this.mt[0] = this.mt[311];
            i = 1;
        }
        this.mt[0] = Long.MIN_VALUE;
    }

    private void initState(long seed) {
        this.mt[0] = seed;
        this.mti = 1;
        while (this.mti < 312) {
            long mm1 = this.mt[this.mti - 1];
            this.mt[this.mti] = 6364136223846793005L * (mm1 ^ mm1 >>> 62) + (long)this.mti;
            ++this.mti;
        }
    }

    @Override
    public long next() {
        long x;
        if (this.mti >= 312) {
            int i;
            for (i = 0; i < 156; ++i) {
                x = this.mt[i] & Integer.MIN_VALUE | this.mt[i + 1] & Integer.MAX_VALUE;
                this.mt[i] = this.mt[i + 156] ^ x >>> 1 ^ MAG01[(int)(x & 1L)];
            }
            for (i = 156; i < 311; ++i) {
                x = this.mt[i] & Integer.MIN_VALUE | this.mt[i + 1] & Integer.MAX_VALUE;
                this.mt[i] = this.mt[i + -156] ^ x >>> 1 ^ MAG01[(int)(x & 1L)];
            }
            x = this.mt[311] & Integer.MIN_VALUE | this.mt[0] & Integer.MAX_VALUE;
            this.mt[311] = this.mt[155] ^ x >>> 1 ^ MAG01[(int)(x & 1L)];
            this.mti = 0;
        }
        x = this.mt[this.mti++];
        x ^= x >>> 29 & 0x5555555555555555L;
        x ^= x << 17 & 0x71D67FFFEDA60000L;
        x ^= x << 37 & 0xFFF7EEE000000000L;
        x ^= x >>> 43;
        return x;
    }
}

