/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.rng.sampling;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.rng.UniformRandomProvider;
import org.apache.commons.rng.sampling.PermutationSampler;

public class ListSampler {
    private ListSampler() {
    }

    public static <T> List<T> sample(UniformRandomProvider rng, List<T> collection, int k) {
        int n = collection.size();
        PermutationSampler p = new PermutationSampler(rng, n, k);
        ArrayList<T> result = new ArrayList<T>(k);
        int[] index = p.sample();
        for (int i = 0; i < k; ++i) {
            result.add(collection.get(index[i]));
        }
        return result;
    }

    public static <T> void shuffle(UniformRandomProvider rng, List<T> list) {
        ListSampler.shuffle(rng, list, 0, false);
    }

    public static <T> void shuffle(UniformRandomProvider rng, List<T> list, int start, boolean towardHead) {
        int len = list.size();
        int[] indices = PermutationSampler.natural(len);
        PermutationSampler.shuffle(rng, indices, start, towardHead);
        ArrayList<T> items = new ArrayList<T>(list);
        for (int i = 0; i < len; ++i) {
            list.set(i, items.get(indices[i]));
        }
    }
}

