/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.rng.sampling.distribution;

import org.apache.commons.rng.UniformRandomProvider;
import org.apache.commons.rng.sampling.distribution.AhrensDieterExponentialSampler;
import org.apache.commons.rng.sampling.distribution.DiscreteSampler;

public class GeometricSampler
implements DiscreteSampler {
    private final DiscreteSampler delegate;

    public GeometricSampler(UniformRandomProvider rng, double probabilityOfSuccess) {
        if (probabilityOfSuccess <= 0.0 || probabilityOfSuccess > 1.0) {
            throw new IllegalArgumentException("Probability of success (p) must be in the range [0 < p <= 1]: " + probabilityOfSuccess);
        }
        this.delegate = probabilityOfSuccess == 1.0 ? GeometricP1Sampler.INSTANCE : new GeometricExponentialSampler(rng, probabilityOfSuccess);
    }

    @Override
    public int sample() {
        return this.delegate.sample();
    }

    public String toString() {
        return this.delegate.toString();
    }

    private static class GeometricP1Sampler
    implements DiscreteSampler {
        static final GeometricP1Sampler INSTANCE = new GeometricP1Sampler();

        private GeometricP1Sampler() {
        }

        @Override
        public int sample() {
            return 0;
        }

        public String toString() {
            return "Geometric(p=1) deviate";
        }
    }

    private static class GeometricExponentialSampler
    implements DiscreteSampler {
        private final UniformRandomProvider rng;
        private final AhrensDieterExponentialSampler exponentialSampler;

        GeometricExponentialSampler(UniformRandomProvider rng, double probabilityOfSuccess) {
            this.rng = rng;
            double exponentialMean = 1.0 / -Math.log1p(-probabilityOfSuccess);
            this.exponentialSampler = new AhrensDieterExponentialSampler(rng, exponentialMean);
        }

        @Override
        public int sample() {
            return (int)Math.floor(this.exponentialSampler.sample());
        }

        public String toString() {
            return "Geometric deviate [" + this.rng.toString() + "]";
        }
    }
}

