/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.statistics.distribution;

import org.apache.commons.rng.UniformRandomProvider;
import org.apache.commons.rng.sampling.distribution.DiscreteSampler;
import org.apache.commons.rng.sampling.distribution.DiscreteUniformSampler;
import org.apache.commons.statistics.distribution.AbstractDiscreteDistribution;
import org.apache.commons.statistics.distribution.DiscreteDistribution;
import org.apache.commons.statistics.distribution.DistributionException;

public class UniformDiscreteDistribution
extends AbstractDiscreteDistribution {
    private static final double ONE_TWELFTH = 0.08333333333333333;
    private final int lower;
    private final int upper;
    private final double upperPlusLower;
    private final double upperMinusLower;

    public UniformDiscreteDistribution(int lower, int upper) {
        if (lower > upper) {
            throw new DistributionException("{0} > {1}", lower, upper);
        }
        this.lower = lower;
        this.upper = upper;
        this.upperPlusLower = (double)upper + (double)lower;
        this.upperMinusLower = (double)upper - (double)lower;
    }

    @Override
    public double probability(int x) {
        if (x < this.lower || x > this.upper) {
            return 0.0;
        }
        return 1.0 / (this.upperMinusLower + 1.0);
    }

    @Override
    public double cumulativeProbability(int x) {
        if (x < this.lower) {
            return 0.0;
        }
        if (x > this.upper) {
            return 1.0;
        }
        return (double)(x - this.lower + 1) / (this.upperMinusLower + 1.0);
    }

    @Override
    public double getMean() {
        return 0.5 * this.upperPlusLower;
    }

    @Override
    public double getVariance() {
        double n = this.upperMinusLower + 1.0;
        return 0.08333333333333333 * (n * n - 1.0);
    }

    @Override
    public int getSupportLowerBound() {
        return this.lower;
    }

    @Override
    public int getSupportUpperBound() {
        return this.upper;
    }

    @Override
    public boolean isSupportConnected() {
        return true;
    }

    @Override
    public DiscreteDistribution.Sampler createSampler(final UniformRandomProvider rng) {
        return new DiscreteDistribution.Sampler(){
            private final DiscreteSampler sampler;
            {
                this.sampler = new DiscreteUniformSampler(rng, UniformDiscreteDistribution.this.lower, UniformDiscreteDistribution.this.upper);
            }

            @Override
            public int sample() {
                return this.sampler.sample();
            }
        };
    }
}

