/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.virtdata.userlibs.streams;

import io.nosqlbench.virtdata.library.basics.shared.from_long.to_bytebuffer.HashedToByteBuffer;
import io.nosqlbench.virtdata.userlibs.streams.fillers.ChunkedByteBuffer;
import io.nosqlbench.virtdata.userlibs.streams.fillers.LongFunctionIterable;
import io.nosqlbench.virtdata.userlibs.streams.pojos.ByteBufferObject;
import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.function.LongFunction;
import org.jetbrains.annotations.NotNull;

public class ByteBufferStreams {
    public static Iterable<ByteBufferObject> byteBufferObjects(long startCycle, long endCycle, int bufsize) {
        HashedToByteBuffer htbb = new HashedToByteBuffer(bufsize);
        LongFunctionIterable<ByteBufferObject> bbi = new LongFunctionIterable<ByteBufferObject>(startCycle, endCycle, l -> new ByteBufferObject(htbb.apply(l)));
        return bbi;
    }

    public static Iterable<ByteBuffer> byteBuffers(long startCycle, long endCycle, int bufsize) {
        HashedToByteBuffer htbb = new HashedToByteBuffer(bufsize);
        LongFunctionIterable<ByteBuffer> bbi = new LongFunctionIterable<ByteBuffer>(startCycle, endCycle, (LongFunction<ByteBuffer>)htbb);
        return bbi;
    }

    public static Iterable<ByteBuffer> partialByteBuffers(int startCycle, int endCycle, int bufSize) {
        Iterable<ByteBuffer> byteBuffers = ByteBufferStreams.byteBuffers(startCycle, endCycle, bufSize);
        return new ChunkedByteBuffer(byteBuffers);
    }

    private static final class ByteBufferObjectIterable
    implements Iterable<ByteBufferObject> {
        private ByteBufferObjectIterable() {
        }

        @Override
        @NotNull
        public Iterator<ByteBufferObject> iterator() {
            return new ByteBufferObjectIterator();
        }

        private static final class ByteBufferObjectIterator
        implements Iterator<ByteBufferObject> {
            private ByteBufferObjectIterator() {
            }

            @Override
            public boolean hasNext() {
                return false;
            }

            @Override
            public ByteBufferObject next() {
                return null;
            }
        }
    }
}

