/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.virtdata.userlibs.streams.fillers;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Iterator;
import org.jetbrains.annotations.NotNull;

public class ChunkedByteBuffer
implements Iterable<ByteBuffer> {
    private final Iterable<ByteBuffer> source;

    public ChunkedByteBuffer(Iterable<ByteBuffer> source) {
        this.source = source;
    }

    @Override
    @NotNull
    public Iterator<ByteBuffer> iterator() {
        return new ChunkedByteBufferIterator(this.source.iterator());
    }

    private static class ChunkedByteBufferIterator
    implements Iterator<ByteBuffer> {
        private final Iterator<ByteBuffer> sourceIter;
        private ByteBuffer buf;
        int chunks;

        public ChunkedByteBufferIterator(Iterator<ByteBuffer> iterator) {
            this.sourceIter = iterator;
        }

        @Override
        public boolean hasNext() {
            if (this.buf != null && this.buf.remaining() <= 0) {
                this.buf = null;
            }
            if (this.buf == null && this.sourceIter.hasNext()) {
                this.buf = this.sourceIter.next();
                ++this.chunks;
            }
            return this.buf != null;
        }

        @Override
        public ByteBuffer next() {
            return this.buf;
        }

        public String toString() {
            return "chunk " + this.chunks + " / position " + (Serializable)(this.buf == null ? "NULL" : Integer.valueOf(this.buf.position()));
        }
    }
}

