/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.virtdata.userlibs.streams.fillers;

import java.util.Iterator;
import java.util.function.LongFunction;
import org.jetbrains.annotations.NotNull;

public class LongFunctionIterable<T>
implements Iterable<T> {
    private final long startCycle;
    private final LongFunction<T> f;
    private final long endCycle;

    public LongFunctionIterable(long startCycle, long endCycle, LongFunction<T> f) {
        this.startCycle = startCycle;
        this.endCycle = endCycle;
        this.f = f;
    }

    @Override
    @NotNull
    public Iterator<T> iterator() {
        return new LongFunctionIterator(this.startCycle, this.endCycle, this.f);
    }

    private class LongFunctionIterator
    implements Iterator<T> {
        private final long endCycle;
        private long cycle;
        private final LongFunction<T> f;

        public LongFunctionIterator(long startCycle, long endCycle, LongFunction<T> f) {
            this.cycle = startCycle;
            this.endCycle = endCycle;
            this.f = f;
        }

        @Override
        public boolean hasNext() {
            return this.cycle < this.endCycle;
        }

        @Override
        public T next() {
            return this.f.apply(this.cycle++);
        }
    }
}

