/*
 * Decompiled with CFR 0.152.
 */
package io.noties.adapt;

import android.content.Context;
import android.util.SparseArray;
import android.view.LayoutInflater;
import android.view.ViewGroup;
import androidx.annotation.CheckResult;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.recyclerview.widget.RecyclerView;
import io.noties.adapt.AdaptException;
import io.noties.adapt.Item;
import io.noties.adapt.NotifyDataSetChanged;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class Adapt
extends RecyclerView.Adapter<Item.Holder> {
    private final DataSetChangeHandler dataSetChangeHandler;
    private final SparseArray<RecyclerView.ItemDecoration> itemDecorations = new SparseArray(0);
    private ItemViewTypeFactory itemViewTypeFactory;
    private LayoutInflater inflater;
    private List<Item> items;
    private Set<Integer> pendingViewTypesRemoved;
    private RecyclerView recyclerView;

    @NonNull
    public static Adapt create() {
        return Adapt.create(NotifyDataSetChanged.create());
    }

    @NonNull
    public static Adapt create(@NonNull DataSetChangeHandler dataSetChangeHandler) {
        return new Adapt(dataSetChangeHandler);
    }

    public Adapt(@NonNull DataSetChangeHandler dataSetChangeHandler) {
        this.dataSetChangeHandler = dataSetChangeHandler;
        super.setHasStableIds(true);
    }

    public void onAttachedToRecyclerView(@NonNull RecyclerView recyclerView) {
        this.recyclerView = recyclerView;
        this.inflater = this.ensureLayoutInflater((ViewGroup)recyclerView);
    }

    public void onDetachedFromRecyclerView(@NonNull RecyclerView recyclerView) {
        this.dataSetChangeHandler.cancel();
        this.removeAllItemDecorations(recyclerView);
        this.recyclerView = null;
        this.inflater = null;
    }

    public void setHasStableIds(boolean hasStableIds) {
    }

    @NonNull
    public RecyclerView recyclerView() {
        return this.ensureRecyclerView();
    }

    @NonNull
    public Item.Holder onCreateViewHolder(@NonNull ViewGroup viewGroup, int itemViewType) {
        Item item = this.ensureItem(itemViewType);
        LayoutInflater inflater = this.ensureLayoutInflater(viewGroup);
        this.ensureItemDecoration(itemViewType, item);
        return item.createHolder(inflater, viewGroup);
    }

    public void onBindViewHolder(@NonNull Item.Holder holder, int position) {
        this.ensureRemovedViewTypesUnregisteredDecorators();
        this.items.get(position).render(holder);
    }

    public void onBindViewHolder(@NonNull Item.Holder holder, int position, @NonNull List<Object> payloads) {
        this.onBindViewHolder(holder, position);
    }

    public int getItemViewType(int position) {
        return this.items.get(position).viewType();
    }

    public long getItemId(int position) {
        return this.items.get(position).id();
    }

    public int getItemCount() {
        return Adapt.safeList(this.items).size();
    }

    @NonNull
    public Item getItem(int position) {
        return this.items.get(position);
    }

    public void setItems(@Nullable List<Item> items) {
        this.setItems(items, null);
    }

    public void setItems(@Nullable List<Item> items, @Nullable ItemViewTypeFactory itemViewTypeFactory) {
        this.dataSetChangeHandler.handleDataSetChange(this, itemViewTypeFactory, Adapt.safeList(this.items), Adapt.safeList(items));
    }

    @NonNull
    public List<Item> getCurrentItems() {
        return Collections.unmodifiableList(Adapt.safeList(this.items));
    }

    @NonNull
    @CheckResult(suggest="#notifyDataSetChanged(),#notifyItemChanged(int),#notifyItemChanged(int, Object),#notifyItemInserted(int),#notifyItemMoved(int, int),#notifyItemRangeChanged(int, int),#notifyItemRangeInserted(int, int),#notifyItemRangeRemoved(int, int),#notifyItemRemoved(int)")
    public Adapt swapItemsBeforeUpdate(@Nullable List<Item> items) {
        return this.swapItemsBeforeUpdate(items, null);
    }

    @NonNull
    @CheckResult(suggest="#notifyDataSetChanged(),#notifyItemChanged(int),#notifyItemChanged(int, Object),#notifyItemInserted(int),#notifyItemMoved(int, int),#notifyItemRangeChanged(int, int),#notifyItemRangeInserted(int, int),#notifyItemRangeRemoved(int, int),#notifyItemRemoved(int)")
    public Adapt swapItemsBeforeUpdate(@Nullable List<Item> items, @Nullable ItemViewTypeFactory itemViewTypeFactory) {
        this.items = items;
        ItemViewTypeFactory factory = itemViewTypeFactory != null ? itemViewTypeFactory : Adapt.createItemViewFactory(items);
        this.pendingViewTypesRemoved = Adapt.extractRemovedViewTypes(this.pendingViewTypesRemoved, this.itemViewTypeFactory, factory);
        this.itemViewTypeFactory = factory;
        return this;
    }

    @NonNull
    private Item ensureItem(int viewType) {
        ItemViewTypeFactory itemViewTypeFactory = this.itemViewTypeFactory;
        if (itemViewTypeFactory == null) {
            throw AdaptException.create("ItemViewTypeFactory is not initialized properly");
        }
        Item item = itemViewTypeFactory.itemWithViewType(viewType);
        if (item == null) {
            throw AdaptException.create("ItemViewTypeFactory returned null item for viewType: %d", viewType);
        }
        return item;
    }

    @NonNull
    private LayoutInflater ensureLayoutInflater(@NonNull ViewGroup group) {
        LayoutInflater inflater = this.inflater;
        if (inflater == null) {
            inflater = this.inflater = LayoutInflater.from((Context)group.getContext());
        }
        return inflater;
    }

    @NonNull
    private RecyclerView ensureRecyclerView() {
        RecyclerView recyclerView = this.recyclerView;
        if (recyclerView == null) {
            throw AdaptException.create("Adapt instance is not attached to RecyclerView");
        }
        return recyclerView;
    }

    private void ensureItemDecoration(int viewType, @NonNull Item item) {
        RecyclerView.ItemDecoration itemDecoration = (RecyclerView.ItemDecoration)this.itemDecorations.get(viewType);
        if (itemDecoration != null) {
            return;
        }
        final RecyclerView recyclerView = this.ensureRecyclerView();
        itemDecoration = item.recyclerDecoration(recyclerView);
        if (itemDecoration == null) {
            return;
        }
        this.itemDecorations.append(viewType, (Object)itemDecoration);
        if (!recyclerView.isComputingLayout()) {
            recyclerView.addItemDecoration(itemDecoration);
        } else {
            final RecyclerView.ItemDecoration decoration = itemDecoration;
            recyclerView.post(new Runnable(){

                @Override
                public void run() {
                    if (!recyclerView.isComputingLayout()) {
                        recyclerView.addItemDecoration(decoration);
                    } else {
                        recyclerView.post((Runnable)this);
                    }
                }
            });
        }
    }

    private void ensureRemovedViewTypesUnregisteredDecorators() {
        final Set<Integer> pendingViewTypesRemoved = this.pendingViewTypesRemoved;
        if (pendingViewTypesRemoved == null || pendingViewTypesRemoved.isEmpty()) {
            return;
        }
        final RecyclerView recyclerView = this.ensureRecyclerView();
        Runnable action = new Runnable(){

            @Override
            public void run() {
                if (recyclerView.isComputingLayout()) {
                    recyclerView.post((Runnable)this);
                    return;
                }
                for (Integer viewType : pendingViewTypesRemoved) {
                    int intValue = viewType;
                    RecyclerView.ItemDecoration decoration = (RecyclerView.ItemDecoration)Adapt.this.itemDecorations.get(intValue);
                    if (decoration == null) continue;
                    Adapt.this.itemDecorations.remove(intValue);
                    recyclerView.removeItemDecoration(decoration);
                }
                pendingViewTypesRemoved.clear();
            }
        };
        action.run();
    }

    private void removeAllItemDecorations(final @NonNull RecyclerView recyclerView) {
        if (this.pendingViewTypesRemoved != null) {
            this.pendingViewTypesRemoved.clear();
        }
        if (this.itemDecorations.size() == 0) {
            return;
        }
        Runnable action = new Runnable(){

            @Override
            public void run() {
                if (recyclerView.isComputingLayout()) {
                    recyclerView.post((Runnable)this);
                } else {
                    int size = Adapt.this.itemDecorations.size();
                    for (int i = 0; i < size; ++i) {
                        recyclerView.removeItemDecoration((RecyclerView.ItemDecoration)Adapt.this.itemDecorations.valueAt(i));
                    }
                    Adapt.this.itemDecorations.clear();
                }
            }
        };
        action.run();
    }

    @Nullable
    private static Set<Integer> extractRemovedViewTypes(@Nullable Set<Integer> pendingViewTypesRemoved, @Nullable ItemViewTypeFactory previous, @NonNull ItemViewTypeFactory current) {
        if (previous == null) {
            return pendingViewTypesRemoved;
        }
        HashSet<Integer> set = new HashSet<Integer>(previous.viewTypes());
        if (pendingViewTypesRemoved != null) {
            set.addAll(pendingViewTypesRemoved);
        }
        set.removeAll(current.viewTypes());
        return set.isEmpty() ? null : set;
    }

    @NonNull
    private static <T> List<T> safeList(@Nullable List<T> list) {
        return list != null ? list : Collections.emptyList();
    }

    @NonNull
    public static ItemViewTypeFactory createItemViewFactory(@Nullable List<Item> items) {
        SparseArray array = new SparseArray(3);
        HashSet<Integer> viewTypes = new HashSet<Integer>(3);
        for (Item item : Adapt.safeList(items)) {
            int viewType = item.viewType();
            int index = array.indexOfKey(viewType);
            if (index >= 0) continue;
            array.append(viewType, (Object)item);
            viewTypes.add(viewType);
        }
        return new ItemViewTypeFactoryImpl((SparseArray<Item>)array, Collections.unmodifiableSet(viewTypes));
    }

    private static class ItemViewTypeFactoryImpl
    implements ItemViewTypeFactory {
        private final SparseArray<Item> items;
        private final Set<Integer> viewTypes;

        ItemViewTypeFactoryImpl(@NonNull SparseArray<Item> items, @NonNull Set<Integer> viewTypes) {
            this.items = items;
            this.viewTypes = viewTypes;
        }

        @Override
        @NonNull
        public Item itemWithViewType(int viewType) {
            return (Item)this.items.get(viewType);
        }

        @Override
        @NonNull
        public Set<Integer> viewTypes() {
            return this.viewTypes;
        }
    }

    public static interface ItemViewTypeFactory {
        @NonNull
        public Item itemWithViewType(int var1);

        @NonNull
        public Set<Integer> viewTypes();
    }

    public static interface DataSetChangeHandler {
        public void handleDataSetChange(@NonNull Adapt var1, @Nullable ItemViewTypeFactory var2, @NonNull List<Item> var3, @NonNull List<Item> var4);

        public void cancel();
    }
}

