/*
 * Decompiled with CFR 0.152.
 */
package io.noties.adapt;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.IdRes;
import androidx.annotation.NonNull;
import io.noties.adapt.AdaptException;
import io.noties.adapt.Item;
import io.noties.adapt.R;
import io.noties.adapt.ViewUtils;

public abstract class AdaptView<I extends Item> {
    @NonNull
    public static <I extends Item> AdaptView<I> append(@NonNull ViewGroup group, @NonNull I item) {
        return AdaptView.append(LayoutInflater.from((Context)group.getContext()), group, item);
    }

    @NonNull
    public static <I extends Item> AdaptView<I> append(@NonNull LayoutInflater inflater, @NonNull ViewGroup group, @NonNull I item) {
        Object holder = item.createHolder(inflater, group);
        View view = ((Item.Holder)((Object)holder)).itemView;
        view.setTag(R.id.adapt_internal_holder, holder);
        group.addView(view);
        item.render(holder);
        view.setTag(R.id.adapt_internal_item, item);
        return new Impl(view);
    }

    @NonNull
    public static <H extends Item.Holder, I extends Item<H>> AdaptView<I> create(@NonNull View view, @NonNull I item, @NonNull HolderProvider<H> holderProvider) {
        H holder = holderProvider.provide(view);
        view.setTag(R.id.adapt_internal_holder, holder);
        item.render(holder);
        view.setTag(R.id.adapt_internal_item, item);
        return new Impl(view);
    }

    @NonNull
    public static <H extends Item.Holder, I extends Item<H>> AdaptView<I> create(@NonNull View parent, @IdRes int viewId, @NonNull I item, @NonNull HolderProvider<H> holderProvider) {
        Object view = ViewUtils.requireView(parent, viewId);
        H holder = holderProvider.provide((View)view);
        view.setTag(R.id.adapt_internal_holder, holder);
        item.render(holder);
        view.setTag(R.id.adapt_internal_item, item);
        return new Impl((View)view);
    }

    public abstract void setItem(@NonNull I var1);

    @NonNull
    public abstract I getCurrentItem();

    @NonNull
    public abstract View view();

    static class Impl<I extends Item>
    extends AdaptView<I> {
        private final View view;

        Impl(@NonNull View view) {
            this.view = view;
        }

        @Override
        public void setItem(@NonNull I item) {
            I currentItem = this.getCurrentItem();
            Item.Holder holder = (Item.Holder)((Object)this.view.getTag(R.id.adapt_internal_holder));
            if (holder == null) {
                throw AdaptException.create("Unexpected state, there is no Holder associated with this view, supplied item: %s, view: %s", item, this.view);
            }
            if (((Item)currentItem).viewType() != ((Item)item).viewType()) {
                throw AdaptException.create("Supplied item has different view-type as previously bound one, previous: `%s`, supplied: `%s`, view: %s", currentItem, item, this.view);
            }
            ((Item)item).render((Item.Holder)holder);
            this.view.setTag(R.id.adapt_internal_item, item);
        }

        @Override
        @NonNull
        public I getCurrentItem() {
            Item currentItem = (Item)this.view.getTag(R.id.adapt_internal_item);
            if (currentItem == null) {
                throw AdaptException.create("Unexpected state, there is no item bound, view: %s", this.view);
            }
            return (I)currentItem;
        }

        @Override
        @NonNull
        public View view() {
            return this.view;
        }
    }

    public static interface HolderProvider<H extends Item.Holder> {
        @NonNull
        public H provide(@NonNull View var1);
    }
}

