/*
 * Decompiled with CFR 0.152.
 */
package io.noties.adapt;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import io.noties.adapt.AdaptException;
import io.noties.adapt.AdaptViewGroupDiff;
import io.noties.adapt.Item;
import io.noties.adapt.R;
import java.util.ArrayList;
import java.util.List;

public abstract class AdaptViewGroup {
    @NonNull
    public static AdaptViewGroup create(@NonNull ViewGroup group) {
        return AdaptViewGroup.builder(group).build();
    }

    @NonNull
    public static Builder builder(@NonNull ViewGroup group) {
        return new BuilderImpl(group);
    }

    @NonNull
    public abstract ViewGroup viewGroup();

    public abstract void setItems(@Nullable List<Item> var1);

    @NonNull
    public abstract List<Item> getCurrentItems();

    static class BuilderImpl
    implements Builder {
        private final ViewGroup group;
        private LayoutInflater layoutInflater;
        private AdaptViewGroupDiff adaptViewGroupDiff;

        BuilderImpl(@NonNull ViewGroup group) {
            this.group = group;
        }

        @Override
        @NonNull
        public Builder layoutInflater(@NonNull LayoutInflater layoutInflater) {
            this.layoutInflater = layoutInflater;
            return this;
        }

        @Override
        @NonNull
        public Builder adaptViewGroupDiff(@NonNull AdaptViewGroupDiff adaptViewGroupDiff) {
            this.adaptViewGroupDiff = adaptViewGroupDiff;
            return this;
        }

        @Override
        @NonNull
        public AdaptViewGroup build() {
            LayoutInflater inflater = this.layoutInflater != null ? this.layoutInflater : LayoutInflater.from((Context)this.group.getContext());
            AdaptViewGroupDiff adaptViewGroupDiff = this.adaptViewGroupDiff != null ? this.adaptViewGroupDiff : AdaptViewGroupDiff.create();
            return new Impl(this.group, inflater, adaptViewGroupDiff);
        }
    }

    static class Impl
    extends AdaptViewGroup
    implements AdaptViewGroupDiff.Parent {
        private final ViewGroup group;
        private final LayoutInflater layoutInflater;
        private final AdaptViewGroupDiff diff;

        Impl(@NonNull ViewGroup group, @NonNull LayoutInflater layoutInflater, @NonNull AdaptViewGroupDiff adaptViewGroupDiff) {
            this.group = group;
            this.layoutInflater = layoutInflater;
            this.diff = adaptViewGroupDiff;
        }

        @Override
        @NonNull
        public ViewGroup viewGroup() {
            return this.group;
        }

        @Override
        public void setItems(@Nullable List<Item> items) {
            if (items == null || items.isEmpty()) {
                this.group.removeAllViews();
                return;
            }
            this.diff.diff(this, this.getCurrentItems(), items);
        }

        @Override
        @NonNull
        public List<Item> getCurrentItems() {
            ArrayList<Item> items = new ArrayList<Item>(this.group.getChildCount());
            int i = 0;
            while (i < this.group.getChildCount()) {
                View view = this.group.getChildAt(i);
                Item item = (Item)view.getTag(R.id.adapt_internal_item);
                if (item == null) {
                    this.group.removeViewAt(i);
                    continue;
                }
                items.add(item);
                ++i;
            }
            return items;
        }

        @Override
        public void removeAt(int index) {
            this.group.removeViewAt(index);
        }

        @Override
        public void move(int from, int to) {
            View child = this.group.getChildAt(from);
            this.group.removeViewAt(from);
            this.group.addView(child, to);
        }

        @Override
        public void insertAt(int index, @NonNull Item item) {
            Object holder = item.createHolder(this.layoutInflater, this.group);
            View view = ((Item.Holder)((Object)holder)).itemView;
            view.setTag(R.id.adapt_internal_holder, holder);
            this.group.addView(view, index);
        }

        @Override
        public void render(int index, @NonNull Item item) {
            View view = this.group.getChildAt(index);
            Item.Holder holder = (Item.Holder)((Object)view.getTag(R.id.adapt_internal_holder));
            if (holder == null) {
                throw AdaptException.create("Internal error, attached view has no Holder saved, view: " + view);
            }
            item.render(holder);
            view.setTag(R.id.adapt_internal_item, (Object)item);
        }
    }

    public static interface Builder {
        @NonNull
        public Builder layoutInflater(@NonNull LayoutInflater var1);

        @NonNull
        public Builder adaptViewGroupDiff(@NonNull AdaptViewGroupDiff var1);

        @NonNull
        public AdaptViewGroup build();
    }
}

