/*
 * Decompiled with CFR 0.152.
 */
package io.noties.adapt;

import androidx.annotation.NonNull;
import io.noties.adapt.Item;
import java.util.ArrayList;
import java.util.List;

public abstract class AdaptViewGroupDiff {
    @NonNull
    public static AdaptViewGroupDiff create() {
        return new Impl();
    }

    public abstract void diff(@NonNull Parent var1, @NonNull List<Item> var2, @NonNull List<Item> var3);

    private static int indexOf(@NonNull List<Item> list, @NonNull Item item) {
        long id2 = item.id();
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            if (id2 != list.get(i).id()) continue;
            return i;
        }
        return -1;
    }

    private static boolean contains(@NonNull List<Item> list, @NonNull Item item) {
        return AdaptViewGroupDiff.indexOf(list, item) >= 0;
    }

    static class Impl
    extends AdaptViewGroupDiff {
        Impl() {
        }

        @Override
        public void diff(@NonNull Parent parent, @NonNull List<Item> previous, @NonNull List<Item> current) {
            ArrayList<Item> list = new ArrayList<Item>(previous);
            for (int i = previous.size() - 1; i >= 0; --i) {
                if (AdaptViewGroupDiff.contains(current, previous.get(i))) continue;
                list.remove(i);
                parent.removeAt(i);
            }
            int count = current.size();
            for (int i = 0; i < count; ++i) {
                Item item = current.get(i);
                int index = AdaptViewGroupDiff.indexOf(list, item);
                if (index >= 0) {
                    if (item.viewType() == ((Item)list.get(index)).viewType()) {
                        if (index != i) {
                            list.remove(index);
                            list.add(i, item);
                            parent.move(index, i);
                        }
                    } else {
                        list.remove(index);
                        parent.removeAt(index);
                        list.add(i, item);
                        parent.insertAt(i, item);
                    }
                } else {
                    list.add(i, item);
                    parent.insertAt(i, item);
                }
                parent.render(i, item);
            }
        }
    }

    public static interface Parent {
        public void removeAt(int var1);

        public void move(int var1, int var2);

        public void insertAt(int var1, @NonNull Item var2);

        public void render(int var1, @NonNull Item var2);
    }
}

