/*
 * Decompiled with CFR 0.152.
 */
package io.noties.adapt;

import android.os.Handler;
import android.os.Looper;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.recyclerview.widget.DiffUtil;
import androidx.recyclerview.widget.RecyclerView;
import io.noties.adapt.Adapt;
import io.noties.adapt.DiffUtilDataSetChanged;
import io.noties.adapt.Item;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;

public class AsyncDiffUtilDataSetChanged
implements Adapt.DataSetChangeHandler {
    private final ExecutorService executorService;
    private final DiffUtilDataSetChanged diffUtilDataSetChanged;
    private final Handler handler = new Handler(Looper.getMainLooper());
    private final AtomicInteger id = new AtomicInteger();
    private Future<?> future;

    @NonNull
    public static AsyncDiffUtilDataSetChanged create() {
        return AsyncDiffUtilDataSetChanged.create(Executors.newCachedThreadPool(), DiffUtilDataSetChanged.create());
    }

    @NonNull
    public static AsyncDiffUtilDataSetChanged create(@NonNull ExecutorService executorService) {
        return AsyncDiffUtilDataSetChanged.create(executorService, DiffUtilDataSetChanged.create());
    }

    @NonNull
    public static AsyncDiffUtilDataSetChanged create(@NonNull DiffUtilDataSetChanged diffUtilDataSetChanged) {
        return AsyncDiffUtilDataSetChanged.create(Executors.newCachedThreadPool(), diffUtilDataSetChanged);
    }

    @NonNull
    public static AsyncDiffUtilDataSetChanged create(@NonNull ExecutorService executorService, @NonNull DiffUtilDataSetChanged diffUtilDataSetChanged) {
        return new AsyncDiffUtilDataSetChanged(executorService, diffUtilDataSetChanged);
    }

    public AsyncDiffUtilDataSetChanged(@NonNull ExecutorService executorService, @NonNull DiffUtilDataSetChanged diffUtilDataSetChanged) {
        this.executorService = executorService;
        this.diffUtilDataSetChanged = diffUtilDataSetChanged;
    }

    @Override
    public void handleDataSetChange(final @NonNull Adapt adapt, final @Nullable Adapt.ItemViewTypeFactory itemViewTypeFactory, final @NonNull List<Item> oldList, final @NonNull List<Item> newList) {
        final int generation = this.id.incrementAndGet();
        if (this.future != null) {
            this.future.cancel(true);
        }
        this.future = this.executorService.submit(new Runnable(){

            @Override
            public void run() {
                Adapt.ItemViewTypeFactory factory;
                final DiffUtil.DiffResult result = AsyncDiffUtilDataSetChanged.this.diffUtilDataSetChanged.diffResult(oldList, newList);
                Adapt.ItemViewTypeFactory itemViewTypeFactory2 = factory = itemViewTypeFactory == null ? Adapt.createItemViewFactory(newList) : itemViewTypeFactory;
                if (generation != AsyncDiffUtilDataSetChanged.this.id.get()) {
                    return;
                }
                AsyncDiffUtilDataSetChanged.this.handler.post(new Runnable(){

                    @Override
                    public void run() {
                        if (generation == AsyncDiffUtilDataSetChanged.this.id.get()) {
                            result.dispatchUpdatesTo((RecyclerView.Adapter)adapt.swapItemsBeforeUpdate(newList, factory));
                        }
                    }
                });
            }
        });
    }

    @Override
    public void cancel() {
        this.id.incrementAndGet();
        if (this.future != null && !this.future.isDone()) {
            this.future.cancel(true);
            this.future = null;
        }
    }
}

