/*
 * Decompiled with CFR 0.152.
 */
package io.noties.adapt;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.recyclerview.widget.DiffUtil;
import androidx.recyclerview.widget.RecyclerView;
import io.noties.adapt.Adapt;
import io.noties.adapt.Item;
import java.util.List;

public class DiffUtilDataSetChanged
implements Adapt.DataSetChangeHandler {
    private final boolean detectMoves;

    @NonNull
    public static DiffUtilDataSetChanged create() {
        return DiffUtilDataSetChanged.create(false);
    }

    @NonNull
    public static DiffUtilDataSetChanged create(boolean detectMoves) {
        return new DiffUtilDataSetChanged(detectMoves);
    }

    public DiffUtilDataSetChanged(boolean detectMoves) {
        this.detectMoves = detectMoves;
    }

    @Override
    public void handleDataSetChange(@NonNull Adapt adapt, @Nullable Adapt.ItemViewTypeFactory itemViewTypeFactory, @NonNull List<Item> oldList, @NonNull List<Item> newList) {
        DiffUtil.DiffResult result = this.diffResult(oldList, newList);
        result.dispatchUpdatesTo((RecyclerView.Adapter)adapt.swapItemsBeforeUpdate(newList, itemViewTypeFactory));
    }

    @Override
    public void cancel() {
    }

    @NonNull
    public DiffUtil.DiffResult diffResult(final @NonNull List<Item> oldList, final @NonNull List<Item> newList) {
        return DiffUtil.calculateDiff((DiffUtil.Callback)new DiffUtil.Callback(){

            public int getOldListSize() {
                return oldList.size();
            }

            public int getNewListSize() {
                return newList.size();
            }

            public boolean areItemsTheSame(int oldItemPosition, int newItemPosition) {
                Item oldItem = (Item)oldList.get(oldItemPosition);
                long oldId = oldItem.id();
                if (oldId == -1L) {
                    return false;
                }
                Item newItem = (Item)newList.get(newItemPosition);
                long newId = newItem.id();
                if (newId == -1L) {
                    return false;
                }
                return oldId == newId && oldItem.viewType() == newItem.viewType();
            }

            public boolean areContentsTheSame(int oldItemPosition, int newItemPosition) {
                return ((Item)oldList.get(oldItemPosition)).equals(newList.get(newItemPosition));
            }
        }, (boolean)this.detectMoves);
    }
}

