/*
 * Decompiled with CFR 0.152.
 */
package io.noties.adapt;

import android.util.SparseIntArray;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.IdRes;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import androidx.recyclerview.widget.RecyclerView;
import io.noties.adapt.ViewUtils;
import java.util.concurrent.atomic.AtomicInteger;

public abstract class Item<H extends Holder> {
    public static final long NO_ID = -1L;
    private static final int NO_VIEW_TYPE = -1;
    protected final long id;
    private int viewType = -1;

    public static int generatedViewType(@NonNull Class<? extends Item> type) {
        return ViewTypeStore.viewType(type);
    }

    protected Item(long id2) {
        this.id = id2;
    }

    public final long id() {
        return this.id;
    }

    @NonNull
    public abstract H createHolder(@NonNull LayoutInflater var1, @NonNull ViewGroup var2);

    public abstract void render(@NonNull H var1);

    public int viewType() {
        int viewType = this.viewType;
        if (viewType == -1) {
            viewType = this.viewType = Item.generatedViewType(this.getClass());
        }
        return viewType;
    }

    @Nullable
    public RecyclerView.ItemDecoration recyclerDecoration(@NonNull RecyclerView recyclerView) {
        return null;
    }

    @VisibleForTesting
    static class ViewTypeStore {
        static final SparseIntArray CACHE = new SparseIntArray();
        static final AtomicInteger GENERATOR = new AtomicInteger();

        ViewTypeStore() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        static int viewType(@NonNull Class<? extends Item> type) {
            int hash = type.hashCode();
            int viewType = CACHE.get(hash, -1);
            if (viewType == -1) {
                SparseIntArray sparseIntArray = CACHE;
                synchronized (sparseIntArray) {
                    viewType = CACHE.get(hash, -1);
                    if (viewType == -1) {
                        viewType = GENERATOR.incrementAndGet();
                        CACHE.put(hash, viewType);
                    }
                }
            }
            return viewType;
        }
    }

    public static class Holder
    extends RecyclerView.ViewHolder {
        public Holder(@NonNull View itemView) {
            super(itemView);
        }

        @NonNull
        protected <V extends View> V requireView(@IdRes int id2) {
            return this.requireView(this.itemView, id2);
        }

        @NonNull
        protected <V extends View> V requireView(@NonNull View view, @IdRes int id2) {
            return ViewUtils.requireView(view, id2);
        }
    }
}

