/*
 * Decompiled with CFR 0.152.
 */
package io.noties.adapt;

import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;
import io.noties.adapt.Adapt;
import io.noties.adapt.Item;
import io.noties.adapt.NestedRecyclerState;
import java.util.List;

public abstract class ItemGroup
extends Item<Holder> {
    private List<Item> children;

    protected ItemGroup(long id2, @NonNull List<Item> children) {
        super(id2);
        this.children = children;
    }

    @NonNull
    public List<Item> getChildren() {
        return this.children;
    }

    public void setChildren(@NonNull List<Item> children) {
        this.children = children;
    }

    @Override
    @NonNull
    public Holder createHolder(@NonNull LayoutInflater inflater, @NonNull ViewGroup parent) {
        View view = this.createView(inflater, parent);
        RecyclerView recyclerView = this.initNestedRecyclerView(view);
        Adapt adapt = this.createNestedAdapt();
        this.processRecyclerViewPool(parent, recyclerView);
        recyclerView.setAdapter((RecyclerView.Adapter)adapt);
        return new Holder(view, recyclerView, adapt);
    }

    @Override
    public void render(@NonNull Holder holder) {
        holder.adapt.setItems(this.children);
        this.processState(holder);
    }

    @NonNull
    protected abstract View createView(@NonNull LayoutInflater var1, @NonNull ViewGroup var2);

    @NonNull
    protected abstract RecyclerView initNestedRecyclerView(@NonNull View var1);

    @NonNull
    protected Adapt createNestedAdapt() {
        return Adapt.create();
    }

    protected void processRecyclerViewPool(@NonNull ViewGroup parent, @NonNull RecyclerView recyclerView) {
        if (parent instanceof RecyclerView) {
            recyclerView.setRecycledViewPool(((RecyclerView)parent).getRecycledViewPool());
        }
    }

    protected void processState(@NonNull Holder holder) {
        NestedRecyclerState.process(this.id(), holder.recyclerView);
    }

    protected static class Holder
    extends Item.Holder {
        public final RecyclerView recyclerView;
        public final Adapt adapt;

        protected Holder(@NonNull View itemView, @NonNull RecyclerView recyclerView, @NonNull Adapt adapt) {
            super(itemView);
            this.recyclerView = recyclerView;
            this.adapt = adapt;
        }
    }
}

