/*
 * Decompiled with CFR 0.152.
 */
package io.noties.adapt;

import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.LayoutRes;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.recyclerview.widget.RecyclerView;
import io.noties.adapt.HasWrappedItem;
import io.noties.adapt.Item;

public class ItemLayoutWrapper<H extends Item.Holder>
extends Item<Holder>
implements HasWrappedItem<H> {
    private final int layout;
    private final Item<H> item;

    @NonNull
    public static <H extends Item.Holder> ItemLayoutWrapper<H> create(@LayoutRes int layout, @NonNull Item<H> item) {
        return new ItemLayoutWrapper<H>(layout, item);
    }

    public ItemLayoutWrapper(@LayoutRes int layout, @NonNull Item<H> item) {
        super(item.id());
        this.layout = layout;
        this.item = item;
    }

    @Override
    @NonNull
    public Holder createHolder(@NonNull LayoutInflater inflater, @NonNull ViewGroup parent) {
        ViewGroup root = (ViewGroup)inflater.inflate(this.layout, parent, false);
        return new Holder(root, (Item.Holder)((Object)this.item.createHolder(inflater, root)));
    }

    @Override
    public void render(@NonNull Holder holder) {
        this.item.render(holder.wrapped);
    }

    @Override
    public int viewType() {
        return this.item.viewType();
    }

    @Override
    @Nullable
    public RecyclerView.ItemDecoration recyclerDecoration(@NonNull RecyclerView recyclerView) {
        return this.item.recyclerDecoration(recyclerView);
    }

    @Override
    @NonNull
    public Item<H> item() {
        return this.item;
    }

    protected static class Holder
    extends Item.Holder {
        protected final Item.Holder wrapped;

        protected Holder(@NonNull ViewGroup itemView, @NonNull Item.Holder wrapped) {
            super((View)itemView);
            this.wrapped = wrapped;
            this.appendWrappedView(itemView, wrapped);
        }

        protected void appendWrappedView(@NonNull ViewGroup group, @NonNull Item.Holder wrapped) {
            group.addView(wrapped.itemView);
        }
    }
}

