/*
 * Decompiled with CFR 0.152.
 */
package io.noties.adapt;

import android.annotation.SuppressLint;
import android.os.Parcelable;
import android.view.View;
import android.view.ViewParent;
import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;
import io.noties.adapt.R;
import java.util.HashMap;
import java.util.Map;

public abstract class NestedRecyclerState {
    public static void process(final long id2, final @NonNull RecyclerView recyclerView) {
        ViewParent parent = recyclerView.getParent();
        if (parent != null) {
            Cache cache = Cache.of(parent);
            cache.restore(id2, recyclerView);
        }
        recyclerView.addOnAttachStateChangeListener(new View.OnAttachStateChangeListener(){

            public void onViewAttachedToWindow(View v) {
                Cache.of(recyclerView.getParent()).restore(id2, recyclerView);
            }

            public void onViewDetachedFromWindow(View v) {
                Cache.of(recyclerView.getParent()).save(id2, recyclerView);
                RecyclerView.LayoutManager layoutManager = recyclerView.getLayoutManager();
                if (layoutManager != null) {
                    layoutManager.scrollToPosition(0);
                }
                recyclerView.removeOnAttachStateChangeListener((View.OnAttachStateChangeListener)this);
            }
        });
    }

    public static void clear(@NonNull View container) {
        Cache.of(container).clear();
    }

    private NestedRecyclerState() {
    }

    private static class Cache {
        @SuppressLint(value={"UseSparseArrays"})
        private final Map<Long, Parcelable> cache = new HashMap<Long, Parcelable>(3);

        private Cache() {
        }

        @NonNull
        static Cache of(@NonNull ViewParent parent) {
            return Cache.of((View)parent);
        }

        @NonNull
        static Cache of(@NonNull View container) {
            Cache cache = (Cache)container.getTag(R.id.adapt_internal_nested_recycler_state_cache);
            if (cache == null) {
                cache = new Cache();
                container.setTag(R.id.adapt_internal_nested_recycler_state_cache, (Object)cache);
                container.addOnAttachStateChangeListener((View.OnAttachStateChangeListener)new DisposeListener(cache));
            }
            return cache;
        }

        void save(long id2, @NonNull RecyclerView recyclerView) {
            RecyclerView.LayoutManager layoutManager = recyclerView.getLayoutManager();
            Parcelable parcelable = layoutManager != null ? layoutManager.onSaveInstanceState() : null;
            if (parcelable == null) {
                this.cache.remove(id2);
            } else {
                this.cache.put(id2, parcelable);
            }
        }

        void restore(long id2, @NonNull RecyclerView recyclerView) {
            Parcelable parcelable = this.cache.remove(id2);
            RecyclerView.LayoutManager layoutManager = recyclerView.getLayoutManager();
            if (parcelable != null && layoutManager != null) {
                layoutManager.onRestoreInstanceState(parcelable);
            }
        }

        void clear() {
            this.cache.clear();
        }

        private static class DisposeListener
        implements View.OnAttachStateChangeListener {
            private final Cache cache;

            DisposeListener(@NonNull Cache cache) {
                this.cache = cache;
            }

            public void onViewAttachedToWindow(View v) {
            }

            public void onViewDetachedFromWindow(View v) {
                this.cache.clear();
                v.removeOnAttachStateChangeListener((View.OnAttachStateChangeListener)this);
                v.setTag(R.id.adapt_internal_nested_recycler_state_cache, null);
            }
        }
    }
}

