/*
 * Decompiled with CFR 0.152.
 */
package io.noties.adapt;

import android.graphics.Canvas;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.widget.FrameLayout;
import android.widget.HorizontalScrollView;
import android.widget.ScrollView;
import androidx.annotation.NonNull;
import androidx.core.view.ScrollingView;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import io.noties.adapt.Adapt;
import io.noties.adapt.AdaptException;
import io.noties.adapt.AdaptView;
import io.noties.adapt.Item;

public class StickyItemDecoration<I extends Item>
extends RecyclerView.ItemDecoration {
    protected static final int MEASURE_SPEC_UNSPECIFIED = View.MeasureSpec.makeMeasureSpec((int)0, (int)0);
    private final AdaptView<I> adaptView;
    private final int stickyViewType;

    @NonNull
    public static <I extends Item> StickyItemDecoration<I> create(@NonNull RecyclerView recyclerView, @NonNull I item) {
        FrameLayout frameLayout = StickyItemDecoration.parentFrameLayout(recyclerView);
        return StickyItemDecoration.create((ViewGroup)frameLayout, item);
    }

    @NonNull
    public static <I extends Item> StickyItemDecoration<I> create(@NonNull ViewGroup parent, @NonNull I item) {
        AdaptView<I> adaptView = AdaptView.append(parent, item);
        return StickyItemDecoration.create(adaptView);
    }

    @NonNull
    public static <I extends Item> StickyItemDecoration<I> create(@NonNull AdaptView<I> adaptView) {
        return new StickyItemDecoration<I>(adaptView);
    }

    @NonNull
    private static FrameLayout parentFrameLayout(@NonNull RecyclerView recyclerView) {
        boolean isScroll;
        ViewParent parent = recyclerView.getParent();
        boolean isFrame = parent instanceof FrameLayout;
        boolean bl = isScroll = isFrame && (parent instanceof ScrollView || parent instanceof HorizontalScrollView || parent instanceof ScrollingView);
        if (isFrame && !isScroll) {
            return (FrameLayout)parent;
        }
        throw AdaptException.create("RecyclerView must be placed inside FrameLayout in order to add sticky view. Consider wrapping RecyclerView inside FrameLayout or use different #create factory method that allows manual placing of sticky view.");
    }

    protected StickyItemDecoration(@NonNull AdaptView<I> adaptView) {
        this.adaptView = adaptView;
        this.stickyViewType = Item.generatedViewType(adaptView.getCurrentItem().getClass());
        this.hideStickyView();
    }

    public void onDrawOver(@NonNull Canvas c, @NonNull RecyclerView parent, @NonNull RecyclerView.State state) {
        int count = parent.getChildCount();
        if (count == 0) {
            this.hideStickyView();
            return;
        }
        RecyclerView.LayoutManager layoutManager = parent.getLayoutManager();
        if (layoutManager == null) {
            this.hideStickyView();
            return;
        }
        if (this.isReverseLayout(layoutManager)) {
            this.processReverseLayout(parent);
        } else {
            this.processRegularLayout(parent);
        }
    }

    protected boolean isReverseLayout(@NonNull RecyclerView.LayoutManager layoutManager) {
        return layoutManager instanceof LinearLayoutManager && ((LinearLayoutManager)layoutManager).getReverseLayout();
    }

    protected void processRegularLayout(@NonNull RecyclerView parent) {
        float y;
        int position;
        View first = parent.getChildAt(0);
        RecyclerView.ViewHolder holder = parent.findContainingViewHolder(first);
        if (holder == null) {
            this.hideStickyView();
            return;
        }
        RecyclerView.Adapter adapter = parent.getAdapter();
        if (!(adapter instanceof Adapt)) {
            this.hideStickyView();
            return;
        }
        Adapt adapt = (Adapt)adapter;
        Item item = null;
        for (position = holder.getAdapterPosition(); position >= 0; --position) {
            if (this.stickyViewType != adapt.getItemViewType(position)) continue;
            item = adapt.getItem(position);
            break;
        }
        if (item == null) {
            this.hideStickyView();
            return;
        }
        ++position;
        int nextStickyViewTop = 0;
        int adapterCount = adapt.getItemCount();
        while (position < adapterCount) {
            if (this.stickyViewType == adapt.getItemViewType(position)) {
                RecyclerView.ViewHolder viewHolder = parent.findViewHolderForAdapterPosition(position);
                nextStickyViewTop = viewHolder != null ? viewHolder.itemView.getTop() : 0;
                break;
            }
            ++position;
        }
        this.adaptView.setItem(item);
        View view = this.prepareStickyView(this.adaptView, parent);
        view.setAlpha(1.0f);
        int height = view.getMeasuredHeight();
        if (nextStickyViewTop > 0 && nextStickyViewTop < height) {
            y = -(height - nextStickyViewTop);
            this.processStickyView(view, (float)nextStickyViewTop / (float)height);
        } else {
            y = 0.0f;
            this.processStickyView(view, 1.0f);
        }
        view.setTranslationY(y);
    }

    protected void processReverseLayout(@NonNull RecyclerView parent) {
        int y;
        LinearLayoutManager manager = (LinearLayoutManager)parent.getLayoutManager();
        if (manager == null) {
            this.hideStickyView();
            return;
        }
        int position = manager.findLastVisibleItemPosition();
        if (position < 0) {
            this.hideStickyView();
            return;
        }
        RecyclerView.Adapter adapter = parent.getAdapter();
        if (!(adapter instanceof Adapt)) {
            this.hideStickyView();
            return;
        }
        Adapt adapt = (Adapt)adapter;
        int adaptCount = adapt.getItemCount();
        Item item = null;
        while (position < adaptCount) {
            if (this.stickyViewType == adapt.getItemViewType(position)) {
                item = adapt.getItem(position);
                break;
            }
            ++position;
        }
        if (item == null) {
            this.hideStickyView();
            return;
        }
        --position;
        int previousStickyViewTop = 0;
        while (position >= 0) {
            if (this.stickyViewType == adapt.getItemViewType(position)) {
                RecyclerView.ViewHolder viewHolder = parent.findViewHolderForAdapterPosition(position);
                previousStickyViewTop = viewHolder != null ? viewHolder.itemView.getTop() : 0;
                break;
            }
            --position;
        }
        this.adaptView.setItem(item);
        View view = this.prepareStickyView(this.adaptView, parent);
        view.setAlpha(1.0f);
        int height = view.getHeight();
        if (previousStickyViewTop > 0 && previousStickyViewTop < height) {
            y = -(height - previousStickyViewTop);
            this.processStickyView(view, (float)previousStickyViewTop / (float)height);
        } else {
            y = 0;
            this.processStickyView(view, 1.0f);
        }
        view.setTranslationY((float)y);
    }

    @NonNull
    protected View prepareStickyView(@NonNull AdaptView<I> adaptView, @NonNull RecyclerView recyclerView) {
        int left = recyclerView.getPaddingLeft();
        int width = recyclerView.getWidth() - left - recyclerView.getPaddingRight();
        View view = adaptView.view();
        view.measure(View.MeasureSpec.makeMeasureSpec((int)width, (int)0x40000000), MEASURE_SPEC_UNSPECIFIED);
        view.layout(left, 0, left + view.getMeasuredWidth(), view.getMeasuredHeight());
        return view;
    }

    protected void processStickyView(@NonNull View view, float ratio) {
    }

    protected void hideStickyView() {
        this.adaptView.view().setAlpha(0.0f);
    }
}

