/*
 * Decompiled with CFR 0.152.
 */
package io.noties.adapt;

import android.content.res.Resources;
import android.view.View;
import androidx.annotation.IdRes;
import androidx.annotation.NonNull;
import io.noties.adapt.AdaptException;

abstract class ViewUtils {
    @NonNull
    static <V extends View> V requireView(@NonNull View view, @IdRes int id2) {
        View v = view.findViewById(id2);
        if (v == null) {
            String message = "View with id: `%s` not found in specified layout: %s";
            try {
                Resources resources = view.getResources();
                String idResourceName = resources != null ? resources.getResourceName(id2) : null;
                throw AdaptException.create("View with id: `%s` not found in specified layout: %s", idResourceName, view);
            }
            catch (Resources.NotFoundException e) {
                throw AdaptException.create(e, "View with id: `%s` not found in specified layout: %s", "null", view);
            }
        }
        return (V)v;
    }

    private ViewUtils() {
    }
}

