/*
 * Decompiled with CFR 0.152.
 */
package io.noties.debug.lint;

import com.android.tools.lint.client.api.UElementHandler;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;

public class DebugLintIssue
extends Detector
implements Detector.UastScanner {
    public static final Issue ISSUE = Issue.create((String)"DebugStringFormat", (String)"String#format arguments mismatch", (String)"Checks if Debug is called with correct pattern and arguments", (Category)Category.PERFORMANCE, (int)10, (Severity)Severity.WARNING, (Implementation)new Implementation(DebugLintIssue.class, Scope.JAVA_FILE_SCOPE));
    private static final Pattern STRING_FORMAT_PATTERN = Pattern.compile("%(\\d+\\$)?([-#+ 0,(<]*)?(\\d+)?(\\.\\d+)?([tT])?([a-zA-Z%])");
    private static final Set<String> METHODS = new HashSet<String>(Arrays.asList("v", "d", "i", "w", "e", "wtf"));

    @Nullable
    public List<Class<? extends UElement>> getApplicableUastTypes() {
        return Collections.singletonList(UCallExpression.class);
    }

    @Nullable
    public UElementHandler createUastHandler(final @NotNull JavaContext context) {
        return new UElementHandler(){

            public void visitCallExpression(@NotNull UCallExpression node) {
                String name;
                PsiMethod psiMethod = node.resolve();
                if (psiMethod != null && context.getEvaluator().isMemberInClass((PsiMember)psiMethod, "io.noties.debug.Debug") && (name = node.getMethodName()) != null && METHODS.contains(name)) {
                    DebugLintIssue.process(context, node);
                }
            }
        };
    }

    private static void process(JavaContext context, UCallExpression expression) {
        ArrayList<UExpression> arguments = new ArrayList<UExpression>(expression.getValueArguments());
        if (arguments.isEmpty()) {
            return;
        }
        if (DebugLintIssue.isSubclassOf(context, (UExpression)arguments.get(0), Throwable.class)) {
            arguments.remove(0);
        }
        if (arguments.isEmpty() || !DebugLintIssue.isSubclassOf(context, (UExpression)arguments.get(0), String.class)) {
            return;
        }
        String pattern = (String)((UExpression)arguments.get(0)).evaluate();
        if (pattern == null || pattern.length() == 0) {
            return;
        }
        Matcher matcher = STRING_FORMAT_PATTERN.matcher(pattern);
        if (matcher.find()) {
            arguments.remove(0);
            Object[] mock = DebugLintIssue.mockArguments(arguments);
            try {
                String.format(pattern, mock);
            }
            catch (Throwable t) {
                context.report(ISSUE, (UElement)expression, context.getLocation((UElement)expression), t.getMessage());
            }
        }
    }

    @Nullable
    private static Object[] mockArguments(List<UExpression> list) {
        if (list.isEmpty()) {
            return null;
        }
        ArrayList<Object> objects = new ArrayList<Object>(list.size());
        for (UExpression expression : list) {
            Object eval = expression.evaluate();
            if (eval != null) {
                objects.add(eval);
                continue;
            }
            PsiType psiType = expression.getExpressionType();
            Object o = PsiType.BOOLEAN.equals((Object)psiType) ? Boolean.valueOf(false) : (PsiType.BYTE.equals((Object)psiType) ? Byte.valueOf((byte)0) : (PsiType.CHAR.equals((Object)psiType) ? Character.valueOf('a') : (PsiType.DOUBLE.equals((Object)psiType) ? Double.valueOf(0.0) : (PsiType.FLOAT.equals((Object)psiType) ? Float.valueOf(0.0f) : (PsiType.INT.equals((Object)psiType) ? Integer.valueOf(0) : (PsiType.LONG.equals((Object)psiType) ? Long.valueOf(0L) : (PsiType.SHORT.equals((Object)psiType) ? Short.valueOf((short)0) : (PsiType.NULL.equals((Object)psiType) ? null : new Object()))))))));
            objects.add(o);
        }
        return objects.toArray();
    }

    private static boolean isSubclassOf(JavaContext context, UExpression expression, Class<?> cls) {
        PsiType expressionType = expression.getExpressionType();
        if (!(expressionType instanceof PsiClassType)) {
            return false;
        }
        PsiClassType classType = (PsiClassType)expressionType;
        PsiClass resolvedClass = classType.resolve();
        return context.getEvaluator().extendsClass(resolvedClass, cls.getName(), false);
    }
}

