/*
 * Decompiled with CFR 0.152.
 */
package io.noties.debug;

import android.text.TextUtils;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import io.noties.debug.DebugOutput;
import io.noties.debug.Level;
import java.io.PrintWriter;
import java.io.StringWriter;

public class AndroidLogDebugOutput
implements DebugOutput {
    private static final int MAX_LENGTH = 4000;
    private final boolean isDebug;

    @NonNull
    public static AndroidLogDebugOutput create(boolean isDebug) {
        return new AndroidLogDebugOutput(isDebug);
    }

    public AndroidLogDebugOutput(boolean isDebug) {
        this.isDebug = isDebug;
    }

    @Override
    public void log(@NonNull Level level, @Nullable Throwable throwable, @NonNull String tag, @Nullable String message) {
        int length;
        if (throwable != null) {
            String trace = AndroidLogDebugOutput.throwableStackTrace(throwable);
            message = TextUtils.isEmpty((CharSequence)message) ? trace : message + "\n" + trace;
        }
        int n = length = message != null ? message.length() : 0;
        if (length == 0) {
            AndroidLogDebugOutput.log(level, tag, " ");
        } else if (length < 4000) {
            AndroidLogDebugOutput.log(level, tag, message);
        } else {
            int start = 0;
            int end = 4000;
            while (end <= length) {
                AndroidLogDebugOutput.log(level, tag, message.substring(start, end));
                if (end == length) break;
                start = end;
                end = start + Math.min(4000, length - start);
            }
        }
    }

    @Override
    public boolean isDebug() {
        return this.isDebug;
    }

    @NonNull
    private static String throwableStackTrace(Throwable throwable) {
        StringWriter writer = new StringWriter();
        PrintWriter printWriter = new PrintWriter(writer);
        throwable.printStackTrace(printWriter);
        return writer.toString();
    }

    private static void log(@NonNull Level level, @NonNull String tag, @NonNull String message) {
        if (Level.WTF == level) {
            Log.wtf((String)tag, (String)message);
        } else {
            Log.println((int)(7 - level.ordinal()), (String)tag, (String)message);
        }
    }
}

