/*
 * Decompiled with CFR 0.152.
 */
package io.noties.debug;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import io.noties.debug.DebugOutput;
import io.noties.debug.DebugOutputContainer;
import io.noties.debug.Level;
import java.util.Arrays;
import java.util.Collection;
import java.util.Locale;
import java.util.regex.Pattern;

public class Debug {
    private static final Debug INSTANCE = new Debug();
    private static final Pattern STRING_FORMAT_PATTERN = Pattern.compile("%(\\d+\\$)?([-#+ 0,(<]*)?(\\d+)?(\\.\\d+)?([tT])?([a-zA-Z%])");
    private static final String FILE_NAME = "Debug.java";
    private static final String STARTING_MESSAGE_PATTERN_LINK = "%1$s(%2$s:%3$d)";
    private static final String TRACE_FIRST_LINE = "trace:\n";
    private static final String DEFAULT_TAG = "io.noties.Debug";
    private DebugOutput output;

    private Debug() {
    }

    public static void init(DebugOutput ... outputs) {
        int length;
        int n = length = outputs != null ? outputs.length : 0;
        DebugOutput out = length == 0 ? null : (length == 1 ? outputs[0] : DebugOutputContainer.create(outputs));
        Debug.INSTANCE.output = out;
    }

    public static void init(@NonNull Collection<? extends DebugOutput> outputs) {
        int length = outputs.size();
        DebugOutput out = length == 0 ? null : (length == 1 ? outputs.iterator().next() : DebugOutputContainer.create(outputs));
        Debug.INSTANCE.output = out;
    }

    public static boolean isDebug() {
        DebugOutput output = Debug.INSTANCE.output;
        return output != null && output.isDebug();
    }

    public static void v() {
        Debug.log(Level.V, null, null);
    }

    public static void v(Object o1) {
        Debug.log(Level.V, null, o1);
    }

    public static void v(Object ... args) {
        Debug.log(Level.V, null, args);
    }

    public static void v(Throwable throwable) {
        Debug.log(Level.V, throwable, null);
    }

    public static void v(Throwable throwable, Object ... args) {
        Debug.log(Level.V, throwable, args);
    }

    public static void d() {
        Debug.log(Level.D, null, null);
    }

    public static void d(Object o1) {
        Debug.log(Level.D, null, o1);
    }

    public static void d(Object ... args) {
        Debug.log(Level.D, null, args);
    }

    public static void d(Throwable throwable) {
        Debug.log(Level.D, throwable, null);
    }

    public static void d(Throwable throwable, Object ... args) {
        Debug.log(Level.D, throwable, args);
    }

    public static void i() {
        Debug.log(Level.I, null, null);
    }

    public static void i(Object o1) {
        Debug.log(Level.I, null, o1);
    }

    public static void i(Object ... args) {
        Debug.log(Level.I, null, args);
    }

    public static void i(Throwable throwable) {
        Debug.log(Level.I, throwable, null);
    }

    public static void i(Throwable throwable, Object ... args) {
        Debug.log(Level.I, throwable, args);
    }

    public static void w() {
        Debug.log(Level.W, null, null);
    }

    public static void w(Object o1) {
        Debug.log(Level.W, null, o1);
    }

    public static void w(Object ... args) {
        Debug.log(Level.W, null, args);
    }

    public static void w(Throwable throwable) {
        Debug.log(Level.W, throwable, null);
    }

    public static void w(Throwable throwable, Object ... args) {
        Debug.log(Level.W, throwable, args);
    }

    public static void e() {
        Debug.log(Level.E, null, null);
    }

    public static void e(Object o1) {
        Debug.log(Level.E, null, o1);
    }

    public static void e(Object ... args) {
        Debug.log(Level.E, null, args);
    }

    public static void e(Throwable throwable) {
        Debug.log(Level.E, throwable, null);
    }

    public static void e(Throwable throwable, Object ... args) {
        Debug.log(Level.E, throwable, args);
    }

    public static void wtf() {
        Debug.log(Level.WTF, null, null);
    }

    public static void wtf(Object o1) {
        Debug.log(Level.WTF, null, o1);
    }

    public static void wtf(Object ... args) {
        Debug.log(Level.WTF, null, args);
    }

    public static void wtf(Throwable throwable) {
        Debug.log(Level.WTF, throwable, null);
    }

    public static void wtf(Throwable throwable, Object ... args) {
        Debug.log(Level.WTF, throwable, args);
    }

    public static void trace() {
        Debug.trace(Level.V, 0);
    }

    public static void trace(Level level) {
        Debug.trace(level, 0);
    }

    public static void trace(int maxItems) {
        Debug.trace(Level.V, maxItems);
    }

    public static void trace(Level level, int maxItems) {
        String message;
        String tag;
        DebugOutput output = Debug.INSTANCE.output;
        if (output == null || !output.isDebug()) {
            return;
        }
        StackTraceElement[] elements = Debug.obtainStackTrace();
        if (elements == null || elements.length == 0) {
            tag = DEFAULT_TAG;
            message = null;
        } else {
            tag = Debug.callerTag(elements[0]);
            message = Debug.traceLogMessage(elements, maxItems);
        }
        output.log(level, null, tag, message);
    }

    private static void log(@NonNull Level level, @Nullable Throwable throwable, @Nullable Object o1) {
        DebugOutput output = Debug.INSTANCE.output;
        if (output == null || !output.isDebug()) {
            return;
        }
        output.log(level, throwable, Debug.callerTag(), Debug.logMessage(o1));
    }

    private static void log(@NonNull Level level, @Nullable Throwable throwable, Object[] args) {
        DebugOutput output = Debug.INSTANCE.output;
        if (output == null || !output.isDebug()) {
            return;
        }
        output.log(level, throwable, Debug.callerTag(), Debug.logMessage(args));
    }

    @NonNull
    private static String callerTag() {
        String out;
        int length;
        StackTraceElement[] elements = new Throwable().getStackTrace();
        int n = length = elements != null ? elements.length : 0;
        if (length == 0) {
            out = DEFAULT_TAG;
        } else {
            int first = -1;
            for (int i = 0; i < length; ++i) {
                if (FILE_NAME.equals(elements[i].getFileName())) continue;
                first = i;
                break;
            }
            out = first > -1 ? Debug.callerTag(elements[first]) : DEFAULT_TAG;
        }
        return out;
    }

    @NonNull
    private static String callerTag(@NonNull StackTraceElement element) {
        return String.format(Locale.US, STARTING_MESSAGE_PATTERN_LINK, element.getMethodName(), element.getFileName(), element.getLineNumber());
    }

    @Nullable
    private static String logMessage(Object ... args) {
        String out;
        int length;
        int n = length = args != null ? args.length : 0;
        if (length == 0) {
            out = null;
        } else {
            Debug.processArrays(args, length);
            if (length == 1) {
                out = String.valueOf(args[0]);
            } else {
                Object first = args[0];
                if (first != null && String.class.equals(first.getClass())) {
                    String pattern = (String)first;
                    if (STRING_FORMAT_PATTERN.matcher(pattern).find()) {
                        Object[] formatArgs = new Object[length - 1];
                        System.arraycopy(args, 1, formatArgs, 0, length - 1);
                        out = String.format(pattern, formatArgs);
                    } else {
                        out = Debug.concat(args, length);
                    }
                } else {
                    out = Debug.concat(args, length);
                }
            }
        }
        return out;
    }

    @NonNull
    private static String concat(@NonNull Object[] args, int length) {
        StringBuilder builder = new StringBuilder();
        builder.append(args[0]);
        for (int i = 1; i < length; ++i) {
            builder.append(", ").append(args[i]);
        }
        return builder.toString();
    }

    @Nullable
    private static StackTraceElement[] obtainStackTrace() {
        StackTraceElement[] out;
        int length;
        StackTraceElement[] elements = new Throwable().getStackTrace();
        int n = length = elements != null ? elements.length : 0;
        if (length == 0) {
            out = null;
        } else {
            int start = -1;
            for (int i = 0; i < length; ++i) {
                if (FILE_NAME.equals(elements[i].getFileName())) continue;
                start = i;
                break;
            }
            if (start > -1) {
                int newLength = length - start;
                out = new StackTraceElement[newLength];
                System.arraycopy(elements, start, out, 0, newLength);
            } else {
                out = elements;
            }
        }
        return out;
    }

    @NonNull
    private static String traceLogMessage(@NonNull StackTraceElement[] elements, int maxItems) {
        StringBuilder builder = new StringBuilder(TRACE_FIRST_LINE);
        String callerTag = null;
        int items = 0;
        for (StackTraceElement element : elements) {
            String fileName = element.getFileName();
            if (callerTag == null) {
                callerTag = fileName;
            }
            if (maxItems > 0 && ++items > maxItems) break;
            builder.append("\tat ").append(element.toString()).append('\n');
        }
        return builder.toString();
    }

    private static void processArrays(@NonNull Object[] args, int length) {
        if (length == 0) {
            return;
        }
        for (int i = 0; i < length; ++i) {
            Class<?> cl;
            Object obj = args[i];
            if (obj == null || !(cl = obj.getClass()).isArray()) continue;
            String replace = cl == byte[].class ? Arrays.toString((byte[])obj) : (cl == short[].class ? Arrays.toString((short[])obj) : (cl == int[].class ? Arrays.toString((int[])obj) : (cl == long[].class ? Arrays.toString((long[])obj) : (cl == char[].class ? Arrays.toString((char[])obj) : (cl == float[].class ? Arrays.toString((float[])obj) : (cl == double[].class ? Arrays.toString((double[])obj) : (cl == boolean[].class ? Arrays.toString((boolean[])obj) : Arrays.deepToString((Object[])obj))))))));
            args[i] = replace;
        }
    }
}

