/*
 * Decompiled with CFR 0.152.
 */
package io.noties.debug;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import io.noties.debug.DebugOutput;
import io.noties.debug.Level;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class DebugOutputContainer
implements DebugOutput {
    private final boolean isDebug;
    private final List<DebugOutput> outputs;

    @NonNull
    public static DebugOutputContainer create(DebugOutput ... outputs) {
        return new DebugOutputContainer(Arrays.asList(outputs));
    }

    @NonNull
    public static DebugOutputContainer create(@NonNull Collection<? extends DebugOutput> outputs) {
        return new DebugOutputContainer(outputs);
    }

    @Deprecated
    public DebugOutputContainer(@NonNull DebugOutput[] outputs) {
        this(Arrays.asList(outputs));
    }

    DebugOutputContainer(@NonNull Collection<? extends DebugOutput> outputs) {
        ArrayList<DebugOutput> list = new ArrayList<DebugOutput>(outputs.size());
        for (DebugOutput debugOutput : outputs) {
            if (debugOutput == null || !debugOutput.isDebug()) continue;
            list.add(debugOutput);
        }
        this.isDebug = list.size() > 0;
        this.outputs = this.isDebug ? Collections.unmodifiableList(list) : Collections.emptyList();
    }

    @Override
    public void log(@NonNull Level level, @Nullable Throwable throwable, @NonNull String tag, @Nullable String message) {
        for (DebugOutput output : this.outputs) {
            output.log(level, throwable, tag, message);
        }
    }

    @Override
    public boolean isDebug() {
        return this.isDebug;
    }
}

