/*
 * Decompiled with CFR 0.152.
 */
package io.noties.markwon.html.tag;

import androidx.annotation.NonNull;
import io.noties.markwon.MarkwonConfiguration;
import io.noties.markwon.MarkwonVisitor;
import io.noties.markwon.RenderProps;
import io.noties.markwon.SpanFactory;
import io.noties.markwon.SpannableBuilder;
import io.noties.markwon.core.CoreProps;
import io.noties.markwon.html.HtmlTag;
import io.noties.markwon.html.MarkwonHtmlRenderer;
import io.noties.markwon.html.TagHandler;
import java.util.Arrays;
import java.util.Collection;
import org.commonmark.node.ListItem;

public class ListHandler
extends TagHandler {
    @Override
    public void handle(@NonNull MarkwonVisitor visitor, @NonNull MarkwonHtmlRenderer renderer, @NonNull HtmlTag tag) {
        if (!tag.isBlock()) {
            return;
        }
        HtmlTag.Block block = tag.getAsBlock();
        boolean ol = "ol".equals(block.name());
        boolean ul = "ul".equals(block.name());
        if (!ol && !ul) {
            return;
        }
        MarkwonConfiguration configuration = visitor.configuration();
        RenderProps renderProps = visitor.renderProps();
        SpanFactory spanFactory = configuration.spansFactory().get(ListItem.class);
        int number = 1;
        int bulletLevel = ListHandler.currentBulletListLevel(block);
        for (HtmlTag.Block child : block.children()) {
            ListHandler.visitChildren(visitor, renderer, child);
            if (spanFactory == null || !"li".equals(child.name())) continue;
            if (ol) {
                CoreProps.LIST_ITEM_TYPE.set(renderProps, (Object)CoreProps.ListItemType.ORDERED);
                CoreProps.ORDERED_LIST_ITEM_NUMBER.set(renderProps, (Object)number++);
            } else {
                CoreProps.LIST_ITEM_TYPE.set(renderProps, (Object)CoreProps.ListItemType.BULLET);
                CoreProps.BULLET_LIST_ITEM_LEVEL.set(renderProps, (Object)bulletLevel);
            }
            SpannableBuilder.setSpans((SpannableBuilder)visitor.builder(), (Object)spanFactory.getSpans(configuration, renderProps), (int)child.start(), (int)child.end());
        }
    }

    @Override
    @NonNull
    public Collection<String> supportedTags() {
        return Arrays.asList("ol", "ul");
    }

    private static int currentBulletListLevel(@NonNull HtmlTag.Block block) {
        int level = 0;
        while ((block = block.parent()) != null) {
            if (!"ul".equals(block.name()) && !"ol".equals(block.name())) continue;
            ++level;
        }
        return level;
    }
}

