/*
 * Decompiled with CFR 0.152.
 */
package io.noties.markwon.html.tag;

import android.text.style.StrikethroughSpan;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import io.noties.markwon.MarkwonConfiguration;
import io.noties.markwon.MarkwonVisitor;
import io.noties.markwon.SpanFactory;
import io.noties.markwon.SpannableBuilder;
import io.noties.markwon.html.HtmlTag;
import io.noties.markwon.html.MarkwonHtmlRenderer;
import io.noties.markwon.html.TagHandler;
import java.util.Arrays;
import java.util.Collection;
import org.commonmark.ext.gfm.strikethrough.Strikethrough;

public class StrikeHandler
extends TagHandler {
    private static final boolean HAS_MARKDOWN_IMPLEMENTATION;

    @Override
    public void handle(@NonNull MarkwonVisitor visitor, @NonNull MarkwonHtmlRenderer renderer, @NonNull HtmlTag tag) {
        if (tag.isBlock()) {
            StrikeHandler.visitChildren(visitor, renderer, tag.getAsBlock());
        }
        SpannableBuilder.setSpans((SpannableBuilder)visitor.builder(), (Object)(HAS_MARKDOWN_IMPLEMENTATION ? StrikeHandler.getMarkdownSpans(visitor) : new StrikethroughSpan()), (int)tag.start(), (int)tag.end());
    }

    @Override
    @NonNull
    public Collection<String> supportedTags() {
        return Arrays.asList("s", "del");
    }

    @Nullable
    private static Object getMarkdownSpans(@NonNull MarkwonVisitor visitor) {
        MarkwonConfiguration configuration = visitor.configuration();
        SpanFactory spanFactory = configuration.spansFactory().get(Strikethrough.class);
        if (spanFactory == null) {
            return null;
        }
        return spanFactory.getSpans(configuration, visitor.renderProps());
    }

    static {
        boolean hasMarkdownImplementation;
        try {
            Class.forName("org.commonmark.ext.gfm.strikethrough.Strikethrough");
            hasMarkdownImplementation = true;
        }
        catch (Throwable t) {
            hasMarkdownImplementation = false;
        }
        HAS_MARKDOWN_IMPLEMENTATION = hasMarkdownImplementation;
    }
}

