/*
 * Decompiled with CFR 0.152.
 */
package io.noties.markwon.image.picasso;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.text.Spanned;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.squareup.picasso.Picasso;
import com.squareup.picasso.RequestCreator;
import com.squareup.picasso.Target;
import io.noties.markwon.AbstractMarkwonPlugin;
import io.noties.markwon.MarkwonConfiguration;
import io.noties.markwon.MarkwonSpansFactory;
import io.noties.markwon.SpanFactory;
import io.noties.markwon.image.AsyncDrawable;
import io.noties.markwon.image.AsyncDrawableLoader;
import io.noties.markwon.image.AsyncDrawableScheduler;
import io.noties.markwon.image.DrawableUtils;
import io.noties.markwon.image.ImageSpanFactory;
import java.util.HashMap;
import java.util.Map;
import org.commonmark.node.Image;

public class PicassoImagesPlugin
extends AbstractMarkwonPlugin {
    private final PicassoAsyncDrawableLoader picassoAsyncDrawableLoader;

    @NonNull
    public static PicassoImagesPlugin create(@NonNull Context context) {
        return PicassoImagesPlugin.create(new Picasso.Builder(context).build());
    }

    @NonNull
    public static PicassoImagesPlugin create(final @NonNull Picasso picasso) {
        return PicassoImagesPlugin.create(new PicassoStore(){

            @Override
            @NonNull
            public RequestCreator load(@NonNull AsyncDrawable drawable) {
                return picasso.load(drawable.getDestination()).tag((Object)drawable);
            }

            @Override
            public void cancel(@NonNull AsyncDrawable drawable) {
                picasso.cancelTag((Object)drawable);
            }
        });
    }

    @NonNull
    public static PicassoImagesPlugin create(@NonNull PicassoStore picassoStore) {
        return new PicassoImagesPlugin(picassoStore);
    }

    PicassoImagesPlugin(@NonNull PicassoStore picassoStore) {
        this.picassoAsyncDrawableLoader = new PicassoAsyncDrawableLoader(picassoStore);
    }

    public void configureConfiguration(@NonNull MarkwonConfiguration.Builder builder) {
        builder.asyncDrawableLoader((AsyncDrawableLoader)this.picassoAsyncDrawableLoader);
    }

    public void configureSpansFactory(@NonNull MarkwonSpansFactory.Builder builder) {
        builder.setFactory(Image.class, (SpanFactory)new ImageSpanFactory());
    }

    public void beforeSetText(@NonNull TextView textView, @NonNull Spanned markdown) {
        AsyncDrawableScheduler.unschedule((TextView)textView);
    }

    public void afterSetText(@NonNull TextView textView) {
        AsyncDrawableScheduler.schedule((TextView)textView);
    }

    private static class PicassoAsyncDrawableLoader
    extends AsyncDrawableLoader {
        private final PicassoStore picassoStore;
        private final Map<AsyncDrawable, AsyncDrawableTarget> cache = new HashMap<AsyncDrawable, AsyncDrawableTarget>(2);

        PicassoAsyncDrawableLoader(@NonNull PicassoStore picassoStore) {
            this.picassoStore = picassoStore;
        }

        public void load(@NonNull AsyncDrawable drawable) {
            AsyncDrawableTarget target = new AsyncDrawableTarget(drawable);
            this.cache.put(drawable, target);
            this.picassoStore.load(drawable).into((Target)target);
        }

        public void cancel(@NonNull AsyncDrawable drawable) {
            this.cache.remove(drawable);
            this.picassoStore.cancel(drawable);
        }

        @Nullable
        public Drawable placeholder(@NonNull AsyncDrawable drawable) {
            return null;
        }

        private class AsyncDrawableTarget
        implements Target {
            private final AsyncDrawable drawable;

            AsyncDrawableTarget(AsyncDrawable drawable) {
                this.drawable = drawable;
            }

            public void onBitmapLoaded(Bitmap bitmap, Picasso.LoadedFrom from) {
                if (PicassoAsyncDrawableLoader.this.cache.remove(this.drawable) != null && this.drawable.isAttached() && bitmap != null) {
                    BitmapDrawable bitmapDrawable = new BitmapDrawable(Resources.getSystem(), bitmap);
                    DrawableUtils.applyIntrinsicBounds((Drawable)bitmapDrawable);
                    this.drawable.setResult((Drawable)bitmapDrawable);
                }
            }

            public void onBitmapFailed(Exception e, Drawable errorDrawable) {
                if (PicassoAsyncDrawableLoader.this.cache.remove(this.drawable) != null && errorDrawable != null && this.drawable.isAttached()) {
                    DrawableUtils.applyIntrinsicBoundsIfEmpty((Drawable)errorDrawable);
                    this.drawable.setResult(errorDrawable);
                }
                e.printStackTrace();
            }

            public void onPrepareLoad(Drawable placeHolderDrawable) {
                if (placeHolderDrawable != null && this.canDeliver()) {
                    DrawableUtils.applyIntrinsicBoundsIfEmpty((Drawable)placeHolderDrawable);
                    this.drawable.setResult(placeHolderDrawable);
                }
            }

            private boolean canDeliver() {
                return this.drawable.isAttached() && PicassoAsyncDrawableLoader.this.cache.containsKey(this.drawable);
            }
        }
    }

    public static interface PicassoStore {
        @NonNull
        public RequestCreator load(@NonNull AsyncDrawable var1);

        public void cancel(@NonNull AsyncDrawable var1);
    }
}

