/*
 * Decompiled with CFR 0.152.
 */
package io.noties.markwon.image;

import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Handler;
import android.os.Looper;
import android.os.SystemClock;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import io.noties.markwon.image.AsyncDrawable;
import io.noties.markwon.image.AsyncDrawableLoader;
import io.noties.markwon.image.AsyncDrawableLoaderBuilder;
import io.noties.markwon.image.DrawableUtils;
import io.noties.markwon.image.ImageItem;
import io.noties.markwon.image.ImagesPlugin;
import io.noties.markwon.image.MediaDecoder;
import io.noties.markwon.image.SchemeHandler;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

class AsyncDrawableLoaderImpl
extends AsyncDrawableLoader {
    private final ExecutorService executorService;
    private final Map<String, SchemeHandler> schemeHandlers;
    private final Map<String, MediaDecoder> mediaDecoders;
    private final MediaDecoder defaultMediaDecoder;
    private final ImagesPlugin.PlaceholderProvider placeholderProvider;
    private final ImagesPlugin.ErrorHandler errorHandler;
    private final Handler handler;
    private final Map<AsyncDrawable, Future<?>> requests = new HashMap(2);

    AsyncDrawableLoaderImpl(@NonNull AsyncDrawableLoaderBuilder builder) {
        this(builder, new Handler(Looper.getMainLooper()));
    }

    @VisibleForTesting
    AsyncDrawableLoaderImpl(@NonNull AsyncDrawableLoaderBuilder builder, @NonNull Handler handler) {
        this.executorService = builder.executorService;
        this.schemeHandlers = builder.schemeHandlers;
        this.mediaDecoders = builder.mediaDecoders;
        this.defaultMediaDecoder = builder.defaultMediaDecoder;
        this.placeholderProvider = builder.placeholderProvider;
        this.errorHandler = builder.errorHandler;
        this.handler = handler;
    }

    public void load(@NonNull AsyncDrawable drawable) {
        Future<?> future = this.requests.get(drawable);
        if (future == null) {
            this.requests.put(drawable, this.execute(drawable));
        }
    }

    public void cancel(@NonNull AsyncDrawable drawable) {
        Future<?> future = this.requests.remove(drawable);
        if (future != null) {
            future.cancel(true);
        }
        this.handler.removeCallbacksAndMessages((Object)drawable);
    }

    @Nullable
    public Drawable placeholder(@NonNull AsyncDrawable drawable) {
        return this.placeholderProvider != null ? this.placeholderProvider.providePlaceholder(drawable) : null;
    }

    @NonNull
    private Future<?> execute(final @NonNull AsyncDrawable asyncDrawable) {
        return this.executorService.submit(new Runnable(){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public void run() {
                Rect bounds;
                String destination = asyncDrawable.getDestination();
                Uri uri = Uri.parse((String)destination);
                Drawable drawable = null;
                try {
                    String scheme = uri.getScheme();
                    if (scheme == null || scheme.length() == 0) {
                        throw new IllegalStateException("No scheme is found: " + destination);
                    }
                    SchemeHandler schemeHandler = (SchemeHandler)AsyncDrawableLoaderImpl.this.schemeHandlers.get(scheme);
                    if (schemeHandler == null) throw new IllegalStateException("No scheme-handler is found: " + destination);
                    ImageItem imageItem = schemeHandler.handle(destination, uri);
                    if (imageItem.hasDecodingNeeded()) {
                        ImageItem.WithDecodingNeeded withDecodingNeeded = imageItem.getAsWithDecodingNeeded();
                        MediaDecoder mediaDecoder = (MediaDecoder)AsyncDrawableLoaderImpl.this.mediaDecoders.get(withDecodingNeeded.contentType());
                        if (mediaDecoder == null) {
                            mediaDecoder = AsyncDrawableLoaderImpl.this.defaultMediaDecoder;
                        }
                        if (mediaDecoder == null) throw new IllegalStateException("No media-decoder is found: " + destination);
                        drawable = mediaDecoder.decode(withDecodingNeeded.contentType(), withDecodingNeeded.inputStream());
                    } else {
                        drawable = imageItem.getAsWithResult().result();
                    }
                }
                catch (Throwable t) {
                    if (AsyncDrawableLoaderImpl.this.errorHandler != null) {
                        drawable = AsyncDrawableLoaderImpl.this.errorHandler.handleError(destination, t);
                    }
                    Log.e((String)"MARKWON-IMAGE", (String)("Error loading image: " + destination), (Throwable)t);
                }
                final Drawable out = drawable;
                if (out != null && ((bounds = out.getBounds()) == null || bounds.isEmpty())) {
                    DrawableUtils.applyIntrinsicBounds((Drawable)out);
                }
                AsyncDrawableLoaderImpl.this.handler.postAtTime(new Runnable(){

                    @Override
                    public void run() {
                        Future future = (Future)AsyncDrawableLoaderImpl.this.requests.remove(asyncDrawable);
                        if (future != null && out != null && asyncDrawable.isAttached()) {
                            asyncDrawable.setResult(out);
                        }
                    }
                }, (Object)asyncDrawable, SystemClock.uptimeMillis());
            }
        });
    }
}

