/*
 * Decompiled with CFR 0.152.
 */
package io.noties.markwon.image.network;

import android.net.Uri;
import androidx.annotation.NonNull;
import io.noties.markwon.image.ImageItem;
import io.noties.markwon.image.SchemeHandler;
import io.noties.markwon.image.network.NetworkSchemeHandler;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collection;
import okhttp3.Call;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;

public class OkHttpNetworkSchemeHandler
extends SchemeHandler {
    private static final String HEADER_CONTENT_TYPE = "Content-Type";
    private final Call.Factory factory;

    @NonNull
    public static OkHttpNetworkSchemeHandler create() {
        return OkHttpNetworkSchemeHandler.create(new OkHttpClient());
    }

    @NonNull
    public static OkHttpNetworkSchemeHandler create(@NonNull OkHttpClient client) {
        return OkHttpNetworkSchemeHandler.create((Call.Factory)client);
    }

    @NonNull
    public static OkHttpNetworkSchemeHandler create(@NonNull Call.Factory factory) {
        return new OkHttpNetworkSchemeHandler(factory);
    }

    OkHttpNetworkSchemeHandler(@NonNull Call.Factory factory) {
        this.factory = factory;
    }

    @Override
    @NonNull
    public ImageItem handle(@NonNull String raw, @NonNull Uri uri) {
        InputStream inputStream;
        Response response;
        Request request = new Request.Builder().url(raw).tag((Object)raw).build();
        try {
            response = this.factory.newCall(request).execute();
        }
        catch (Throwable t) {
            throw new IllegalStateException("Exception obtaining network resource: " + raw, t);
        }
        if (response == null) {
            throw new IllegalStateException("Could not obtain network response: " + raw);
        }
        ResponseBody body = response.body();
        InputStream inputStream2 = inputStream = body != null ? body.byteStream() : null;
        if (inputStream == null) {
            throw new IllegalStateException("Response does not contain body: " + raw);
        }
        String contentType = NetworkSchemeHandler.contentType(response.header(HEADER_CONTENT_TYPE));
        return ImageItem.withDecodingNeeded(contentType, inputStream);
    }

    @Override
    @NonNull
    public Collection<String> supportedSchemes() {
        return Arrays.asList("http", "https");
    }
}

