/*
 * Decompiled with CFR 0.152.
 */
package io.noties.markwon.image;

import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import io.noties.markwon.image.MediaDecoder;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Collections;

public class DefaultDownScalingMediaDecoder
extends MediaDecoder {
    private final Resources resources;
    private final int maxWidth;
    private final int maxHeight;

    @NonNull
    public static DefaultDownScalingMediaDecoder create(int maxWidth, int maxHeight) {
        return DefaultDownScalingMediaDecoder.create(Resources.getSystem(), maxWidth, maxHeight);
    }

    @NonNull
    public static DefaultDownScalingMediaDecoder create(@NonNull Resources resources, int maxWidth, int maxHeight) {
        return new DefaultDownScalingMediaDecoder(resources, maxWidth, maxHeight);
    }

    private DefaultDownScalingMediaDecoder(@NonNull Resources resources, int maxWidth, int maxHeight) {
        this.resources = resources;
        this.maxWidth = maxWidth;
        this.maxHeight = maxHeight;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NonNull
    public Drawable decode(@Nullable String contentType, @NonNull InputStream inputStream) {
        File file = DefaultDownScalingMediaDecoder.writeToTempFile(inputStream);
        try {
            BitmapFactory.Options options = new BitmapFactory.Options();
            options.inJustDecodeBounds = true;
            DefaultDownScalingMediaDecoder.decode(file, options);
            options.inSampleSize = DefaultDownScalingMediaDecoder.calculateInSampleSize(options, this.maxWidth, this.maxHeight);
            options.inJustDecodeBounds = false;
            Bitmap bitmap = DefaultDownScalingMediaDecoder.decode(file, options);
            BitmapDrawable bitmapDrawable = new BitmapDrawable(this.resources, bitmap);
            return bitmapDrawable;
        }
        finally {
            file.delete();
        }
    }

    @NonNull
    private static File writeToTempFile(@NonNull InputStream inputStream) {
        BufferedOutputStream outputStream;
        File file;
        try {
            file = File.createTempFile("markwon", null);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        try {
            outputStream = new BufferedOutputStream(new FileOutputStream(file, false));
        }
        catch (FileNotFoundException e) {
            throw new IllegalStateException(e);
        }
        byte[] buffer = new byte[8192];
        try {
            int length;
            while ((length = inputStream.read(buffer)) > 0) {
                ((OutputStream)outputStream).write(buffer, 0, length);
            }
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        finally {
            try {
                ((OutputStream)outputStream).close();
            }
            catch (IOException iOException) {}
        }
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private static Bitmap decode(@NonNull File file, @NonNull BitmapFactory.Options options) {
        InputStream is = DefaultDownScalingMediaDecoder.readFile(file);
        try {
            Bitmap bitmap = BitmapFactory.decodeStream((InputStream)is, null, (BitmapFactory.Options)options);
            return bitmap;
        }
        finally {
            try {
                is.close();
            }
            catch (IOException iOException) {}
        }
    }

    @NonNull
    private static InputStream readFile(@NonNull File file) {
        try {
            return new BufferedInputStream(new FileInputStream(file));
        }
        catch (FileNotFoundException e) {
            throw new IllegalStateException(e);
        }
    }

    private static int calculateInSampleSize(@NonNull BitmapFactory.Options options, int maxWidth, int maxHeight) {
        boolean hasMaxHeight;
        int w = options.outWidth;
        int h = options.outHeight;
        boolean hasMaxWidth = maxWidth > 0;
        boolean bl = hasMaxHeight = maxHeight > 0;
        int inSampleSize = hasMaxWidth && hasMaxHeight ? Math.min(DefaultDownScalingMediaDecoder.calculateInSampleSize(w, maxWidth), DefaultDownScalingMediaDecoder.calculateInSampleSize(h, maxHeight)) : (hasMaxWidth ? DefaultDownScalingMediaDecoder.calculateInSampleSize(w, maxWidth) : (hasMaxHeight ? DefaultDownScalingMediaDecoder.calculateInSampleSize(h, maxHeight) : 1));
        return inSampleSize;
    }

    private static int calculateInSampleSize(int actual, int max) {
        int inSampleSize = 1;
        int half = actual / 2;
        while (half / inSampleSize > max) {
            inSampleSize *= 2;
        }
        return inSampleSize;
    }

    @Override
    @NonNull
    public Collection<String> supportedTypes() {
        return Collections.emptySet();
    }
}

