/*
 * Decompiled with CFR 0.152.
 */
package io.noties.markwon.inlineparser;

import io.noties.markwon.inlineparser.InlineProcessor;
import java.util.regex.Pattern;
import org.commonmark.node.Link;
import org.commonmark.node.Node;
import org.commonmark.node.Text;

public class AutolinkInlineProcessor
extends InlineProcessor {
    private static final Pattern EMAIL_AUTOLINK = Pattern.compile("^<([a-zA-Z0-9.!#$%&'*+/=?^_`{|}~-]+@[a-zA-Z0-9](?:[a-zA-Z0-9-]{0,61}[a-zA-Z0-9])?(?:\\.[a-zA-Z0-9](?:[a-zA-Z0-9-]{0,61}[a-zA-Z0-9])?)*)>");
    private static final Pattern AUTOLINK = Pattern.compile("^<[a-zA-Z][a-zA-Z0-9.+-]{1,31}:[^<>\u0000- ]*>");

    @Override
    public char specialCharacter() {
        return '<';
    }

    @Override
    protected Node parse() {
        String m = this.match(EMAIL_AUTOLINK);
        if (m != null) {
            String dest = m.substring(1, m.length() - 1);
            Link node = new Link("mailto:" + dest, null);
            node.appendChild((Node)new Text(dest));
            return node;
        }
        m = this.match(AUTOLINK);
        if (m != null) {
            String dest = m.substring(1, m.length() - 1);
            Link node = new Link(dest, null);
            node.appendChild((Node)new Text(dest));
            return node;
        }
        return null;
    }
}

