/*
 * Decompiled with CFR 0.152.
 */
package io.noties.markwon.recycler;

import android.content.Context;
import android.util.SparseArray;
import android.view.LayoutInflater;
import android.view.ViewGroup;
import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;
import io.noties.markwon.Markwon;
import io.noties.markwon.MarkwonReducer;
import io.noties.markwon.recycler.MarkwonAdapter;
import java.util.Collections;
import java.util.List;
import org.commonmark.node.Node;

class MarkwonAdapterImpl
extends MarkwonAdapter {
    private final SparseArray<MarkwonAdapter.Entry<Node, MarkwonAdapter.Holder>> entries;
    private final MarkwonAdapter.Entry<Node, MarkwonAdapter.Holder> defaultEntry;
    private final MarkwonReducer reducer;
    private LayoutInflater layoutInflater;
    private Markwon markwon;
    private List<Node> nodes;

    MarkwonAdapterImpl(@NonNull SparseArray<MarkwonAdapter.Entry<Node, MarkwonAdapter.Holder>> entries, @NonNull MarkwonAdapter.Entry<Node, MarkwonAdapter.Holder> defaultEntry, @NonNull MarkwonReducer reducer) {
        this.entries = entries;
        this.defaultEntry = defaultEntry;
        this.reducer = reducer;
        this.setHasStableIds(true);
    }

    @Override
    public void setMarkdown(@NonNull Markwon markwon, @NonNull String markdown) {
        this.setParsedMarkdown(markwon, markwon.parse(markdown));
    }

    @Override
    public void setParsedMarkdown(@NonNull Markwon markwon, @NonNull Node document) {
        this.setParsedMarkdown(markwon, this.reducer.reduce(document));
    }

    @Override
    public void setParsedMarkdown(@NonNull Markwon markwon, @NonNull List<Node> nodes) {
        this.defaultEntry.clear();
        int size = this.entries.size();
        for (int i = 0; i < size; ++i) {
            ((MarkwonAdapter.Entry)this.entries.valueAt(i)).clear();
        }
        this.markwon = markwon;
        this.nodes = nodes;
    }

    @NonNull
    public MarkwonAdapter.Holder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        if (this.layoutInflater == null) {
            this.layoutInflater = LayoutInflater.from((Context)parent.getContext());
        }
        MarkwonAdapter.Entry<Node, MarkwonAdapter.Holder> entry = this.getEntry(viewType);
        return entry.createHolder(this.layoutInflater, parent);
    }

    public void onBindViewHolder(@NonNull MarkwonAdapter.Holder holder, int position) {
        Node node = this.nodes.get(position);
        int viewType = this.getNodeViewType(node.getClass());
        MarkwonAdapter.Entry<Node, MarkwonAdapter.Holder> entry = this.getEntry(viewType);
        entry.bindHolder(this.markwon, holder, node);
    }

    public int getItemCount() {
        return this.nodes != null ? this.nodes.size() : 0;
    }

    public void onViewRecycled(@NonNull MarkwonAdapter.Holder holder) {
        super.onViewRecycled((RecyclerView.ViewHolder)holder);
        MarkwonAdapter.Entry<Node, MarkwonAdapter.Holder> entry = this.getEntry(holder.getItemViewType());
        entry.onViewRecycled(holder);
    }

    @NonNull
    public List<Node> getItems() {
        return this.nodes != null ? Collections.unmodifiableList(this.nodes) : Collections.emptyList();
    }

    public int getItemViewType(int position) {
        return this.getNodeViewType(this.nodes.get(position).getClass());
    }

    public long getItemId(int position) {
        Node node = this.nodes.get(position);
        int type = this.getNodeViewType(node.getClass());
        MarkwonAdapter.Entry<Node, MarkwonAdapter.Holder> entry = this.getEntry(type);
        return entry.id(node);
    }

    @Override
    public int getNodeViewType(@NonNull Class<? extends Node> node) {
        int hash = node.hashCode();
        if (this.entries.indexOfKey(hash) > -1) {
            return hash;
        }
        return 0;
    }

    @NonNull
    private MarkwonAdapter.Entry<Node, MarkwonAdapter.Holder> getEntry(int viewType) {
        return viewType == 0 ? this.defaultEntry : (MarkwonAdapter.Entry)this.entries.get(viewType);
    }

    static class BuilderImpl
    implements MarkwonAdapter.Builder {
        private final SparseArray<MarkwonAdapter.Entry<Node, MarkwonAdapter.Holder>> entries = new SparseArray(3);
        private final MarkwonAdapter.Entry<Node, MarkwonAdapter.Holder> defaultEntry;
        private MarkwonReducer reducer;

        BuilderImpl(@NonNull MarkwonAdapter.Entry<Node, MarkwonAdapter.Holder> defaultEntry) {
            this.defaultEntry = defaultEntry;
        }

        @Override
        @NonNull
        public <N extends Node> MarkwonAdapter.Builder include(@NonNull Class<N> node, @NonNull MarkwonAdapter.Entry<? super N, ? extends MarkwonAdapter.Holder> entry) {
            this.entries.append(node.hashCode(), entry);
            return this;
        }

        @Override
        @NonNull
        public MarkwonAdapter.Builder reducer(@NonNull MarkwonReducer reducer) {
            this.reducer = reducer;
            return this;
        }

        @Override
        @NonNull
        public MarkwonAdapter build() {
            if (this.reducer == null) {
                this.reducer = MarkwonReducer.directChildren();
            }
            return new MarkwonAdapterImpl(this.entries, this.defaultEntry, this.reducer);
        }
    }
}

