/*
 * Decompiled with CFR 0.152.
 */
package io.noties.markwon.recycler;

import android.text.Spannable;
import android.text.Spanned;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import androidx.annotation.IdRes;
import androidx.annotation.LayoutRes;
import androidx.annotation.NonNull;
import io.noties.markwon.Markwon;
import io.noties.markwon.recycler.MarkwonAdapter;
import io.noties.markwon.utils.NoCopySpannableFactory;
import java.util.HashMap;
import java.util.Map;
import org.commonmark.node.Node;

public class SimpleEntry
extends MarkwonAdapter.Entry<Node, Holder> {
    private final Map<Node, Spanned> cache = new HashMap<Node, Spanned>();
    private final int layoutResId;
    private final int textViewIdRes;

    @NonNull
    public static SimpleEntry createTextViewIsRoot(@LayoutRes int layoutResId) {
        return new SimpleEntry(layoutResId, 0);
    }

    @NonNull
    public static SimpleEntry create(@LayoutRes int layoutResId, @IdRes int textViewIdRes) {
        return new SimpleEntry(layoutResId, textViewIdRes);
    }

    public SimpleEntry(@LayoutRes int layoutResId, @IdRes int textViewIdRes) {
        this.layoutResId = layoutResId;
        this.textViewIdRes = textViewIdRes;
    }

    @Override
    @NonNull
    public Holder createHolder(@NonNull LayoutInflater inflater, @NonNull ViewGroup parent) {
        return new Holder(this.textViewIdRes, inflater.inflate(this.layoutResId, parent, false));
    }

    @Override
    public void bindHolder(@NonNull Markwon markwon, @NonNull Holder holder, @NonNull Node node) {
        Spanned spanned = this.cache.get(node);
        if (spanned == null) {
            spanned = markwon.render(node);
            this.cache.put(node, spanned);
        }
        markwon.setParsedMarkdown(holder.textView, spanned);
    }

    @Override
    public void clear() {
        this.cache.clear();
    }

    public static class Holder
    extends MarkwonAdapter.Holder {
        final TextView textView;

        protected Holder(@IdRes int textViewIdRes, @NonNull View itemView) {
            super(itemView);
            TextView textView;
            if (textViewIdRes == 0) {
                if (!(itemView instanceof TextView)) {
                    throw new IllegalStateException("TextView is not root of layout (specify TextView ID explicitly): " + itemView);
                }
                textView = (TextView)itemView;
            } else {
                textView = (TextView)this.requireView(textViewIdRes);
            }
            this.textView = textView;
            this.textView.setSpannableFactory((Spannable.Factory)NoCopySpannableFactory.getInstance());
        }
    }
}

