/*
 * Decompiled with CFR 0.152.
 */
package io.objectbox.gradle.transform;

import com.android.build.api.transform.DirectoryInput;
import com.android.build.api.transform.Format;
import com.android.build.api.transform.JarInput;
import com.android.build.api.transform.QualifiedContent;
import com.android.build.api.transform.Transform;
import com.android.build.api.transform.TransformInput;
import com.android.build.api.transform.TransformInvocation;
import io.objectbox.gradle.transform.ClassProber;
import io.objectbox.gradle.transform.ClassTransformer;
import io.objectbox.gradle.transform.ObjectBoxAndroidTransform;
import io.objectbox.gradle.transform.TransformException;
import io.objectbox.logging.Logging;
import io.objectbox.reporting.BasicBuildTracker;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.gradle.api.provider.Property;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u000e\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0016J\b\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\n\u0012\u0006\b\u0000\u0012\u00020\f0\u0007H\u0016J\b\u0010\r\u001a\u00020\u0004H\u0016J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lio/objectbox/gradle/transform/ObjectBoxAndroidTransform;", "Lcom/android/build/api/transform/Transform;", "debug", "Lorg/gradle/api/provider/Property;", "", "(Lorg/gradle/api/provider/Property;)V", "getInputTypes", "", "Lcom/android/build/api/transform/QualifiedContent$ContentType;", "getName", "", "getScopes", "Lcom/android/build/api/transform/QualifiedContent$Scope;", "isIncremental", "transform", "", "info", "Lcom/android/build/api/transform/TransformInvocation;", "agp-wrapper-3-4"})
public final class ObjectBoxAndroidTransform
extends Transform {
    @NotNull
    private final Property<Boolean> debug;

    public ObjectBoxAndroidTransform(@NotNull Property<Boolean> debug) {
        Intrinsics.checkParameterIsNotNull(debug, (String)"debug");
        this.debug = debug;
    }

    @NotNull
    public String getName() {
        return "ObjectBoxAndroidTransform";
    }

    @NotNull
    public Set<QualifiedContent.ContentType> getInputTypes() {
        Object[] objectArray = new QualifiedContent.ContentType[]{(QualifiedContent.ContentType)QualifiedContent.DefaultContentType.CLASSES};
        return SetsKt.mutableSetOf((Object[])objectArray);
    }

    @NotNull
    public Set<? super QualifiedContent.Scope> getScopes() {
        Object[] objectArray = new QualifiedContent.Scope[]{QualifiedContent.Scope.PROJECT};
        return SetsKt.mutableSetOf((Object[])objectArray);
    }

    public boolean isIncremental() {
        return false;
    }

    public void transform(@NotNull TransformInvocation info) {
        Intrinsics.checkParameterIsNotNull((Object)info, (String)"info");
        super.transform(info);
        Boolean debug = (Boolean)this.debug.get();
        try {
            boolean bl = false;
            List probedClasses = new ArrayList();
            ClassProber classProber = new ClassProber();
            Collection collection = info.getInputs();
            Intrinsics.checkExpressionValueIsNotNull((Object)collection, (String)"info.inputs");
            Iterable $this$forEach$iv = collection;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                TransformInput transformInput = (TransformInput)element$iv;
                boolean bl2 = false;
                Collection collection2 = transformInput.getDirectoryInputs();
                Intrinsics.checkExpressionValueIsNotNull((Object)collection2, (String)"transformInput.directoryInputs");
                Iterable $this$forEach$iv2 = collection2;
                boolean $i$f$forEach2 = false;
                for (Object element$iv2 : $this$forEach$iv2) {
                    DirectoryInput directoryInput = (DirectoryInput)element$iv2;
                    boolean bl3 = false;
                    Intrinsics.checkExpressionValueIsNotNull((Object)debug, (String)"debug");
                    if (debug.booleanValue()) {
                        Logging.log((String)("Input directory: " + directoryInput.getName() + ' ' + directoryInput.getFile()));
                    }
                    File outDir = info.getOutputProvider().getContentLocation(directoryInput.getName(), this.getOutputTypes(), this.getScopes(), Format.DIRECTORY);
                    if (debug.booleanValue()) {
                        Logging.log((String)Intrinsics.stringPlus((String)"Output directory: ", (Object)outDir));
                    }
                    int classes = 0;
                    int copied = 0;
                    File file = directoryInput.getFile();
                    Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"directoryInput.file");
                    Sequence $this$forEach$iv3 = SequencesKt.filter((Sequence)((Sequence)FilesKt.walk$default((File)file, null, (int)1, null)), (Function1)transform.1.1.1.INSTANCE);
                    boolean $i$f$forEach3 = false;
                    for (Object element$iv3 : $this$forEach$iv3) {
                        File file2;
                        File file3 = (File)element$iv3;
                        boolean bl4 = false;
                        Object object = file3.getName();
                        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"file.name");
                        if (StringsKt.endsWith$default((String)object, (String)".class", (boolean)false, (int)2, null)) {
                            object = probedClasses;
                            Intrinsics.checkExpressionValueIsNotNull((Object)outDir, (String)"outDir");
                            file2 = classProber.probeClass(file3, outDir);
                            boolean bl5 = false;
                            object.add(file2);
                            ++classes;
                            continue;
                        }
                        file2 = directoryInput.getFile();
                        Intrinsics.checkExpressionValueIsNotNull((Object)file2, (String)"directoryInput.file");
                        String relativePath = FilesKt.toRelativeString((File)file3, (File)file2);
                        File destFile = new File(outDir, relativePath);
                        FilesKt.copyTo$default((File)file3, (File)destFile, (boolean)true, (int)0, (int)4, null);
                        ++copied;
                    }
                    if (!debug.booleanValue()) continue;
                    Logging.log((String)("Copied " + copied + " files, will check " + classes + " classes if transform required."));
                }
                $this$forEach$iv2 = transformInput.getJarInputs();
                Intrinsics.checkExpressionValueIsNotNull((Object)$this$forEach$iv2, (String)"transformInput.jarInputs");
                $i$f$forEach2 = false;
                for (Object element$iv2 : $this$forEach$iv2) {
                    JarInput jarInput = (JarInput)element$iv2;
                    boolean bl6 = false;
                    Intrinsics.checkExpressionValueIsNotNull((Object)debug, (String)"debug");
                    if (debug.booleanValue()) {
                        Logging.log((String)("Input JAR: " + jarInput.getName() + ' ' + jarInput.getFile()));
                    }
                    File outFileJar = info.getOutputProvider().getContentLocation(jarInput.getName(), this.getOutputTypes(), this.getScopes(), Format.JAR);
                    File file = jarInput.getFile();
                    Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"jarInput.file");
                    Intrinsics.checkExpressionValueIsNotNull((Object)outFileJar, (String)"outFileJar");
                    FilesKt.copyTo$default((File)file, (File)outFileJar, (boolean)true, (int)0, (int)4, null);
                    if (!debug.booleanValue()) continue;
                    Logging.log((String)Intrinsics.stringPlus((String)"Output JAR: ", (Object)outFileJar));
                }
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)debug, (String)"debug");
            ClassTransformer.transformOrCopyClasses$default((ClassTransformer)new ClassTransformer(debug.booleanValue()), (List)probedClasses, (boolean)false, (int)2, null);
        }
        catch (Throwable e) {
            BasicBuildTracker buildTracker = new BasicBuildTracker("Transformer");
            if (e instanceof TransformException) {
                buildTracker.trackError("Transform failed", e);
            } else {
                buildTracker.trackFatal("Transform failed", e);
            }
            throw e;
        }
    }
}

