/*
 * Decompiled with CFR 0.152.
 */
package io.objectbox.gradle.transform;

import com.android.build.api.transform.Transform;
import com.android.build.gradle.AppExtension;
import com.android.build.gradle.BaseExtension;
import com.android.build.gradle.FeatureExtension;
import com.android.build.gradle.LibraryExtension;
import com.android.build.gradle.api.ApplicationVariant;
import com.android.build.gradle.api.BaseVariant;
import com.android.build.gradle.api.FeatureVariant;
import com.android.build.gradle.api.LibraryVariant;
import com.android.build.gradle.api.UnitTestVariant;
import io.objectbox.gradle.transform.AndroidPluginCompat;
import io.objectbox.gradle.transform.ObjectBoxAndroidTransform;
import io.objectbox.gradle.transform.ObjectBoxTestClassesTransformTask;
import java.io.File;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.api.Action;
import org.gradle.api.DomainObjectSet;
import org.gradle.api.Project;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.DefaultDomainObjectSet;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.api.tasks.compile.JavaCompile;
import org.gradle.api.tasks.testing.Test;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.gradle.plugin.KotlinBasePluginWrapper;
import org.jetbrains.kotlin.gradle.tasks.KotlinCompile;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0012\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0007\u001a\u00020\bH\u0016J6\u0010\r\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J&\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\u0011\u001a\u00020\u0010H\u0016\u00a8\u0006\u0016"}, d2={"Lio/objectbox/gradle/transform/AndroidPlugin34;", "Lio/objectbox/gradle/transform/AndroidPluginCompat;", "()V", "addDestinationDirOfKotlinCompile", "", "inputClasspath", "Lorg/gradle/api/file/ConfigurableFileCollection;", "project", "Lorg/gradle/api/Project;", "variant", "Lcom/android/build/gradle/api/BaseVariant;", "getFirstApplicationId", "", "injectTransformTask", "debug", "Lorg/gradle/api/provider/Property;", "", "hasKotlinPlugin", "baseVariant", "unitTestVariant", "Lcom/android/build/gradle/api/UnitTestVariant;", "registerTransform", "agp-wrapper-3-4"})
public class AndroidPlugin34
extends AndroidPluginCompat {
    public void registerTransform(@NotNull Project project, @NotNull Property<Boolean> debug, boolean hasKotlinPlugin) {
        BaseExtension baseExtension;
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull(debug, (String)"debug");
        BaseExtension baseExtension2 = (BaseExtension)project.getExtensions().findByType(BaseExtension.class);
        if (baseExtension2 == null) {
            String string = "The Android Gradle plugin BaseExtension was not found.";
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        BaseExtension androidExtension = baseExtension = baseExtension2;
        androidExtension.registerTransform((Transform)new ObjectBoxAndroidTransform(debug), new Object[0]);
        baseExtension = androidExtension;
        if (baseExtension instanceof AppExtension) {
            ((AppExtension)androidExtension).getApplicationVariants().all(arg_0 -> AndroidPlugin34.registerTransform$lambda-0(this, project, debug, hasKotlinPlugin, arg_0));
        } else if (baseExtension instanceof FeatureExtension) {
            ((FeatureExtension)androidExtension).getFeatureVariants().all(arg_0 -> AndroidPlugin34.registerTransform$lambda-1(this, project, debug, hasKotlinPlugin, arg_0));
        } else if (baseExtension instanceof LibraryExtension) {
            ((LibraryExtension)androidExtension).getLibraryVariants().all(arg_0 -> AndroidPlugin34.registerTransform$lambda-2(this, project, debug, hasKotlinPlugin, arg_0));
        }
    }

    private final void injectTransformTask(Project project, Property<Boolean> debug, boolean hasKotlinPlugin, BaseVariant baseVariant, UnitTestVariant unitTestVariant) {
        Object[] objectArray = new Object[]{baseVariant.getJavaCompileProvider().map(AndroidPlugin34::injectTransformTask$lambda-3)};
        ConfigurableFileCollection inputClasspath = project.files(objectArray);
        objectArray = new Object[]{unitTestVariant.getJavaCompileProvider().map(AndroidPlugin34::injectTransformTask$lambda-4)};
        inputClasspath.from(objectArray);
        if (hasKotlinPlugin) {
            project.getPlugins().withType(KotlinBasePluginWrapper.class, arg_0 -> AndroidPlugin34.injectTransformTask$lambda-5(this, inputClasspath, project, baseVariant, unitTestVariant, arg_0));
        }
        String string = unitTestVariant.getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"unitTestVariant.name");
        String unitTestVariantNameCapitalized = StringsKt.capitalize((String)string);
        String transformTaskName = Intrinsics.stringPlus((String)"objectboxTransform", (Object)unitTestVariantNameCapitalized);
        File file = project.getBuildDir();
        Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"project.buildDir");
        File outputDir = FilesKt.resolve((File)file, (String)Intrinsics.stringPlus((String)"intermediates/objectbox/", (Object)unitTestVariant.getDirName()));
        TaskContainer taskContainer = project.getTasks();
        Intrinsics.checkExpressionValueIsNotNull((Object)inputClasspath, (String)"inputClasspath");
        TaskProvider transformTask = taskContainer.register(transformTaskName, ObjectBoxTestClassesTransformTask.class, (Action)new ObjectBoxTestClassesTransformTask.ConfigAction(debug, outputDir, (FileCollection)inputClasspath));
        Object[] objectArray2 = new Object[]{transformTask.map(AndroidPlugin34::injectTransformTask$lambda-6)};
        ConfigurableFileCollection outputFileCollection = project.files(objectArray2);
        TaskProvider testTaskProvider = project.getTasks().named(Intrinsics.stringPlus((String)"test", (Object)unitTestVariantNameCapitalized), Test.class);
        testTaskProvider.configure(arg_0 -> AndroidPlugin34.injectTransformTask$lambda-7(outputFileCollection, arg_0));
    }

    private final void addDestinationDirOfKotlinCompile(ConfigurableFileCollection inputClasspath, Project project, BaseVariant variant) {
        String string = variant.getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"variant.name");
        String variantNameCapitalized = StringsKt.capitalize((String)string);
        String kotlinTaskName = "compile" + variantNameCapitalized + "Kotlin";
        TaskProvider kotlinCompileTaskProvider = project.getTasks().named(kotlinTaskName, KotlinCompile.class);
        Object[] objectArray = new Object[]{kotlinCompileTaskProvider.map(AndroidPlugin34::addDestinationDirOfKotlinCompile$lambda-8)};
        inputClasspath.from(objectArray);
    }

    @Nullable
    public String getFirstApplicationId(@NotNull Project project) {
        String string;
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        BaseExtension androidExtension = (BaseExtension)project.getExtensions().findByType(BaseExtension.class);
        if (androidExtension instanceof AppExtension) {
            DomainObjectSet domainObjectSet = ((AppExtension)androidExtension).getApplicationVariants();
            Intrinsics.checkExpressionValueIsNotNull((Object)domainObjectSet, (String)"androidExtension.applicationVariants");
            ApplicationVariant applicationVariant = (ApplicationVariant)CollectionsKt.firstOrNull((Iterable)((Iterable)domainObjectSet));
            string = applicationVariant == null ? null : applicationVariant.getApplicationId();
        } else if (androidExtension instanceof LibraryExtension) {
            DefaultDomainObjectSet defaultDomainObjectSet = ((LibraryExtension)androidExtension).getLibraryVariants();
            Intrinsics.checkExpressionValueIsNotNull((Object)defaultDomainObjectSet, (String)"androidExtension.libraryVariants");
            LibraryVariant libraryVariant = (LibraryVariant)CollectionsKt.firstOrNull((Iterable)((Iterable)defaultDomainObjectSet));
            string = libraryVariant == null ? null : libraryVariant.getApplicationId();
        } else {
            string = null;
        }
        return string;
    }

    private static final void registerTransform$lambda-0(AndroidPlugin34 this$0, Project $project, Property $debug, boolean $hasKotlinPlugin, ApplicationVariant it) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkParameterIsNotNull((Object)$project, (String)"$project");
        Intrinsics.checkParameterIsNotNull((Object)$debug, (String)"$debug");
        Intrinsics.checkExpressionValueIsNotNull((Object)it, (String)"it");
        BaseVariant baseVariant = (BaseVariant)it;
        UnitTestVariant unitTestVariant = it.getUnitTestVariant();
        Intrinsics.checkExpressionValueIsNotNull((Object)unitTestVariant, (String)"it.unitTestVariant");
        this$0.injectTransformTask($project, (Property<Boolean>)$debug, $hasKotlinPlugin, baseVariant, unitTestVariant);
    }

    private static final void registerTransform$lambda-1(AndroidPlugin34 this$0, Project $project, Property $debug, boolean $hasKotlinPlugin, FeatureVariant it) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkParameterIsNotNull((Object)$project, (String)"$project");
        Intrinsics.checkParameterIsNotNull((Object)$debug, (String)"$debug");
        Intrinsics.checkExpressionValueIsNotNull((Object)it, (String)"it");
        BaseVariant baseVariant = (BaseVariant)it;
        UnitTestVariant unitTestVariant = it.getUnitTestVariant();
        Intrinsics.checkExpressionValueIsNotNull((Object)unitTestVariant, (String)"it.unitTestVariant");
        this$0.injectTransformTask($project, (Property<Boolean>)$debug, $hasKotlinPlugin, baseVariant, unitTestVariant);
    }

    private static final void registerTransform$lambda-2(AndroidPlugin34 this$0, Project $project, Property $debug, boolean $hasKotlinPlugin, LibraryVariant it) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkParameterIsNotNull((Object)$project, (String)"$project");
        Intrinsics.checkParameterIsNotNull((Object)$debug, (String)"$debug");
        Intrinsics.checkExpressionValueIsNotNull((Object)it, (String)"it");
        BaseVariant baseVariant = (BaseVariant)it;
        UnitTestVariant unitTestVariant = it.getUnitTestVariant();
        Intrinsics.checkExpressionValueIsNotNull((Object)unitTestVariant, (String)"it.unitTestVariant");
        this$0.injectTransformTask($project, (Property<Boolean>)$debug, $hasKotlinPlugin, baseVariant, unitTestVariant);
    }

    private static final DirectoryProperty injectTransformTask$lambda-3(JavaCompile it) {
        return it.getDestinationDirectory();
    }

    private static final DirectoryProperty injectTransformTask$lambda-4(JavaCompile it) {
        return it.getDestinationDirectory();
    }

    private static final void injectTransformTask$lambda-5(AndroidPlugin34 this$0, ConfigurableFileCollection $inputClasspath, Project $project, BaseVariant $baseVariant, UnitTestVariant $unitTestVariant, KotlinBasePluginWrapper it) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkParameterIsNotNull((Object)$project, (String)"$project");
        Intrinsics.checkParameterIsNotNull((Object)$baseVariant, (String)"$baseVariant");
        Intrinsics.checkParameterIsNotNull((Object)$unitTestVariant, (String)"$unitTestVariant");
        Intrinsics.checkExpressionValueIsNotNull((Object)$inputClasspath, (String)"inputClasspath");
        this$0.addDestinationDirOfKotlinCompile($inputClasspath, $project, $baseVariant);
        this$0.addDestinationDirOfKotlinCompile($inputClasspath, $project, (BaseVariant)$unitTestVariant);
    }

    private static final DirectoryProperty injectTransformTask$lambda-6(ObjectBoxTestClassesTransformTask it) {
        return it.getOutputDir();
    }

    private static final void injectTransformTask$lambda-7(ConfigurableFileCollection $outputFileCollection, Test it) {
        it.setClasspath($outputFileCollection.plus(it.getClasspath()));
    }

    private static final DirectoryProperty addDestinationDirOfKotlinCompile$lambda-8(KotlinCompile it) {
        return it.getDestinationDirectory();
    }
}

