/*
 * Decompiled with CFR 0.152.
 */
package io.objectbox.gradle;

import io.objectbox.gradle.GradleBuildTracker;
import io.objectbox.gradle.ProjectEnv;
import io.objectbox.reporting.ObjectBoxBuildConfig;
import java.io.File;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.DefaultTask;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.TaskAction;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001B\u0017\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\r\u001a\u00020\u000eH\u0007J\b\u0010\u000f\u001a\u00020\u000eH\u0002R\u0016\u0010\u0007\u001a\u00020\b8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0016\u0010\u000b\u001a\n \f*\u0004\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lio/objectbox/gradle/PrepareTask;", "Lorg/gradle/api/DefaultTask;", "env", "Lio/objectbox/gradle/ProjectEnv;", "buildTracker", "Lio/objectbox/gradle/GradleBuildTracker;", "(Lio/objectbox/gradle/ProjectEnv;Lio/objectbox/gradle/GradleBuildTracker;)V", "buildConfigFile", "Ljava/io/File;", "getBuildConfigFile", "()Ljava/io/File;", "buildDir", "kotlin.jvm.PlatformType", "run", "", "writeBuildConfig", "objectbox-gradle-plugin"})
public class PrepareTask
extends DefaultTask {
    private final File buildDir;
    @OutputFile
    @NotNull
    private final File buildConfigFile;
    private final ProjectEnv env;
    private final GradleBuildTracker buildTracker;

    @NotNull
    public final File getBuildConfigFile() {
        return this.buildConfigFile;
    }

    @TaskAction
    public final void run() {
        Dependency foundDependency;
        Dependency dependency;
        Configuration aptConf;
        Configuration configuration;
        Configuration configuration2;
        this.buildTracker.trackBuild(this.env);
        Project project = this.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"project");
        Configuration configuration3 = (Configuration)project.getConfigurations().findByName("kapt");
        if (configuration3 == null) {
            Project project2 = this.getProject();
            Intrinsics.checkExpressionValueIsNotNull((Object)project2, (String)"project");
            configuration3 = configuration2 = (Configuration)project2.getConfigurations().findByName("annotationProcessor");
        }
        if (configuration3 == null) {
            Project project3 = this.getProject();
            Intrinsics.checkExpressionValueIsNotNull((Object)project3, (String)"project");
            configuration2 = (Configuration)project3.getConfigurations().findByName("apt");
        }
        if ((configuration = (aptConf = configuration2)) != null && (configuration = configuration.getDependencies()) != null) {
            Object v7;
            block7: {
                Iterable $this$firstOrNull$iv = (Iterable)configuration;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    Dependency dep = (Dependency)element$iv;
                    boolean bl = false;
                    Dependency dependency2 = dep;
                    Intrinsics.checkExpressionValueIsNotNull((Object)dependency2, (String)"dep");
                    if (!Intrinsics.areEqual((Object)dependency2.getGroup(), (Object)"io.objectbox")) continue;
                    v7 = element$iv;
                    break block7;
                }
                v7 = null;
            }
            dependency = v7;
        } else {
            dependency = foundDependency = null;
        }
        if (foundDependency == null) {
            String msg = "No ObjectBox annotation processor configuration found. Please check your build scripts.";
            if (!this.env.getHasAndroidPlugin()) {
                msg = msg + "Currently only Android projects are fully supported.";
            }
            throw (Throwable)new RuntimeException(msg);
        }
        this.writeBuildConfig();
    }

    private final void writeBuildConfig() {
        if (!this.buildDir.exists()) {
            this.buildDir.mkdirs();
        }
        File file = this.env.getProject().getProjectDir();
        Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"env.project.projectDir");
        String string = file.getAbsolutePath();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"env.project.projectDir.absolutePath");
        ObjectBoxBuildConfig objectBoxBuildConfig = new ObjectBoxBuildConfig(string, null);
        File file2 = this.buildDir;
        Intrinsics.checkExpressionValueIsNotNull((Object)file2, (String)"buildDir");
        objectBoxBuildConfig.writeInto(file2);
    }

    @Inject
    public PrepareTask(@NotNull ProjectEnv env, @NotNull GradleBuildTracker buildTracker) {
        Intrinsics.checkParameterIsNotNull((Object)env, (String)"env");
        Intrinsics.checkParameterIsNotNull((Object)((Object)buildTracker), (String)"buildTracker");
        this.env = env;
        this.buildTracker = buildTracker;
        File file = this.buildDir = this.env.getProject().getBuildDir();
        Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"buildDir");
        this.buildConfigFile = ObjectBoxBuildConfig.Companion.buildFile(file);
        this.setGroup("objectbox");
    }
}

