/*
 * Decompiled with CFR 0.152.
 */
package io.objectbox.gradle.transform;

import io.objectbox.BoxStoreBuilder;
import io.objectbox.gradle.transform.ClassConst;
import io.objectbox.gradle.transform.ClassTransformerStats;
import io.objectbox.gradle.transform.JavaAssistExtensionsKt;
import io.objectbox.gradle.transform.PrefixedClassPath;
import io.objectbox.gradle.transform.ProbedClass;
import io.objectbox.gradle.transform.TransformException;
import io.objectbox.logging.Logging;
import io.objectbox.reporting.BasicBuildTracker;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URL;
import java.net.URLDecoder;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javassist.ClassPath;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtConstructor;
import javassist.CtField;
import javassist.CtMethod;
import javassist.Modifier;
import javassist.NotFoundException;
import javassist.bytecode.ClassFile;
import javassist.bytecode.CodeAttribute;
import javassist.bytecode.CodeIterator;
import javassist.bytecode.ConstPool;
import javassist.bytecode.Descriptor;
import javassist.bytecode.FieldInfo;
import javassist.bytecode.MethodInfo;
import javassist.bytecode.SignatureAttribute;
import javassist.expr.ExprEditor;
import javassist.expr.FieldAccess;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u00029:B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J \u0010\u0007\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0003H\u0002J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0018\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J6\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u00172\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0019\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u001a\u001a\u00020\u00122\u0006\u0010\u001b\u001a\u00020\u0012H\u0002J(\u0010\u001c\u001a\u00020\u00122\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001b\u001a\u00020\u0012H\u0002J(\u0010\u001f\u001a\u0012\u0012\u0004\u0012\u00020\u00120 j\b\u0012\u0004\u0012\u00020\u0012`!2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J&\u0010\"\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0012\u0012\u0004\u0012\u00020$0#2\u0006\u0010%\u001a\u00020\u00122\u0006\u0010&\u001a\u00020$H\u0002J\u0018\u0010'\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010(\u001a\u00020)H\u0002J&\u0010*\u001a\u00020\u000e2\u0006\u0010\n\u001a\u00020\u000b2\f\u0010+\u001a\b\u0012\u0004\u0012\u00020)0,2\u0006\u0010(\u001a\u00020)H\u0002J.\u0010-\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0019\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\t2\f\u0010.\u001a\b\u0012\u0004\u0012\u00020\u00180,H\u0002J \u0010/\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\t2\u0006\u00100\u001a\u0002012\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0010\u00102\u001a\u00020\u000e2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0010\u00103\u001a\u00020\u000e2\u0006\u0010\n\u001a\u00020\u000bH\u0002J(\u00104\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0019\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\t2\u0006\u00105\u001a\u00020)H\u0002J \u00106\u001a\u00020\u000e2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0019\u001a\u00020\t2\u0006\u0010(\u001a\u00020)H\u0002J\u0014\u00107\u001a\u0002082\f\u0010+\u001a\b\u0012\u0004\u0012\u00020)0,R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006;"}, d2={"Lio/objectbox/gradle/transform/ClassTransformer;", "", "debug", "", "(Z)V", "getDebug", "()Z", "checkBoxStoreField", "ctClass", "Ljavassist/CtClass;", "context", "Lio/objectbox/gradle/transform/ClassTransformer$Context;", "hasRelations", "checkEntityIsInClassPool", "", "classPool", "Ljavassist/ClassPool;", "signature", "", "checkMakeParamCtClasses", "constructor", "Ljavassist/CtConstructor;", "findRelationFields", "", "Lio/objectbox/gradle/transform/ClassTransformer$RelationField;", "ctClassEntity", "fieldTypeDescriptor", "relationType", "findRelationNameInEntityInfo", "field", "Ljavassist/CtField;", "getInitializedFields", "Ljava/util/HashSet;", "Lkotlin/collections/HashSet;", "getParamType", "Lkotlin/Pair;", "", "descriptor", "charIndexVal", "makeCtClass", "probedClass", "Lio/objectbox/gradle/transform/ProbedClass;", "makeCtClasses", "probedClasses", "", "transformConstructors", "relationFields", "transformCursor", "outDir", "Ljava/io/File;", "transformCursors", "transformEntities", "transformEntity", "entityClass", "transformEntityAndBases", "transformOrCopyClasses", "Lio/objectbox/gradle/transform/ClassTransformerStats;", "Context", "RelationField", "objectbox-gradle-plugin"})
public final class ClassTransformer {
    private final boolean debug;

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final ClassTransformerStats transformOrCopyClasses(@NotNull List<ProbedClass> probedClasses) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkParameterIsNotNull(probedClasses, (String)"probedClasses");
        Context context = new Context(probedClasses);
        Iterable $this$forEach$iv = probedClasses;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ProbedClass it = (ProbedClass)element$iv;
            boolean bl = false;
            if (!it.isEntityInfo()) continue;
            this.makeCtClass(context, it);
        }
        $this$forEach$iv = probedClasses;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ProbedClass probedClass = (ProbedClass)element$iv;
            boolean bl = false;
            if (!probedClass.isEntity()) continue;
            this.makeCtClasses(context, probedClasses, probedClass);
            Iterable $this$forEach$iv2 = probedClass.getInterfaces();
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                String it = (String)element$iv2;
                boolean bl2 = false;
                context.getClassPool().makeClass(it);
            }
        }
        this.transformEntities(context);
        this.transformCursors(context);
        Iterable $this$filter$iv = probedClasses;
        boolean $i$f$filter = false;
        Iterator iterator = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            ProbedClass it = (ProbedClass)element$iv$iv;
            boolean bl = false;
            if (!(!context.wasTransformed(it))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$forEach$iv = (List)destination$iv$iv;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            void file;
            void outDir;
            Object element$iv$iv;
            ProbedClass $dstr$outDir$file$name = (ProbedClass)element$iv;
            boolean bl = false;
            element$iv$iv = $dstr$outDir$file$name.component1();
            File it = $dstr$outDir$file$name.component2();
            String name = $dstr$outDir$file$name.component3();
            File targetFile = new File((File)outDir, StringsKt.replace$default((String)name, (char)'.', (char)'/', (boolean)false, (int)4, null) + ".class");
            if (!(Intrinsics.areEqual((Object)file.getPath(), (Object)targetFile.getPath()) ^ true)) continue;
            FilesKt.copyTo$default((File)file, (File)targetFile, (boolean)true, (int)0, (int)4, null);
        }
        context.getStats().setCountTransformed(context.getTransformedClasses().size());
        context.getStats().setCountCopied(probedClasses.size() - context.getTransformedClasses().size());
        context.getStats().done();
        return context.getStats();
    }

    /*
     * WARNING - void declaration
     */
    private final void transformEntities(Context context) {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = context.getProbedClasses();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            ProbedClass it = (ProbedClass)element$iv$iv;
            boolean bl = false;
            if (!it.isEntity()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            CtClass ctClass;
            ProbedClass entityClass = (ProbedClass)element$iv;
            boolean bl = false;
            if (context.getCtByProbedClass().get(entityClass) == null) {
                Intrinsics.throwNpe();
            }
            this.transformEntityAndBases(context, ctClass, entityClass);
        }
    }

    private final void transformEntityAndBases(Context context, CtClass ctClassEntity, ProbedClass probedClass) {
        CtClass ctClass;
        if (probedClass.getSuperClass() != null) {
            Object v0;
            boolean bl;
            Object object;
            block9: {
                object = context.getProbedClasses();
                bl = false;
                Iterable iterable = object;
                boolean bl2 = false;
                for (Object t : iterable) {
                    ProbedClass it = (ProbedClass)t;
                    boolean bl3 = false;
                    if (!Intrinsics.areEqual((Object)it.getName(), (Object)probedClass.getSuperClass())) continue;
                    v0 = t;
                    break block9;
                }
                v0 = null;
            }
            ProbedClass probedClass2 = v0;
            if (probedClass2 != null) {
                object = probedClass2;
                bl = false;
                boolean bl4 = false;
                Object superClass = object;
                boolean bl5 = false;
                this.transformEntityAndBases(context, ctClassEntity, (ProbedClass)superClass);
            }
        }
        if ((ctClass = context.getCtByProbedClass().get(probedClass)) != null) {
            if (Intrinsics.areEqual((Object)ctClass, (Object)ctClassEntity) ^ true && probedClass.hasRelation(context.getEntityTypes()) && (probedClass.isEntity() || probedClass.isBaseEntity())) {
                throw (Throwable)new TransformException("Relations in an entity super class are not supported, but " + '\'' + ctClass.getName() + "' is super of entity '" + ctClassEntity.getName() + "' and has relations");
            }
            if (Intrinsics.areEqual((Object)ctClass, (Object)ctClassEntity) || probedClass.isBaseEntity()) {
                try {
                    if (this.transformEntity(context, ctClassEntity, ctClass, probedClass)) {
                        context.getTransformedClasses().add(probedClass);
                    }
                }
                catch (Exception e) {
                    throw (Throwable)new TransformException("Could not transform class \"" + ctClass.getName() + "\" (" + e.getMessage() + ')', e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final CtClass makeCtClass(Context context, ProbedClass probedClass) {
        Object object = probedClass.getFile();
        boolean bl = false;
        object = new FileInputStream((File)object);
        bl = false;
        Throwable throwable = null;
        try {
            FileInputStream it = (FileInputStream)object;
            boolean bl2 = false;
            CtClass ctClass = context.getClassPool().makeClass((InputStream)it);
            Map<ProbedClass, CtClass> map = context.getCtByProbedClass();
            CtClass ctClass2 = ctClass;
            Intrinsics.checkExpressionValueIsNotNull((Object)ctClass2, (String)"ctClass");
            map.put(probedClass, ctClass2);
            CtClass ctClass3 = ctClass;
            return ctClass3;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
        }
    }

    private final void makeCtClasses(Context context, List<ProbedClass> probedClasses, ProbedClass probedClass) {
        if (probedClass.getSuperClass() != null) {
            CharSequence charSequence = probedClass.getSuperClass();
            boolean bl = false;
            if (charSequence.length() > 0) {
                Object v0;
                block4: {
                    Iterable iterable = probedClasses;
                    boolean bl2 = false;
                    Iterable iterable2 = iterable;
                    boolean bl3 = false;
                    for (Object t : iterable2) {
                        ProbedClass it = (ProbedClass)t;
                        boolean bl4 = false;
                        if (!Intrinsics.areEqual((Object)it.getName(), (Object)probedClass.getSuperClass())) continue;
                        v0 = t;
                        break block4;
                    }
                    v0 = null;
                }
                ProbedClass superClass = v0;
                if (superClass != null) {
                    this.makeCtClasses(context, probedClasses, superClass);
                }
            }
        }
        this.makeCtClass(context, probedClass);
    }

    private final boolean transformEntity(Context context, CtClass ctClassEntity, CtClass ctClass, ProbedClass entityClass) {
        boolean hasRelations = entityClass.hasRelation(context.getEntityTypes());
        if (this.debug) {
            Logging.log((String)("Checking to transform \"" + ctClass.getName() + "\" (has relations: " + hasRelations + ')'));
        }
        boolean changed = this.checkBoxStoreField(ctClass, context, hasRelations);
        if (hasRelations) {
            List<RelationField> toOneFields = this.findRelationFields(context, ctClassEntity, ctClass, "Lio/objectbox/relation/ToOne;", "io.objectbox.relation.ToOne");
            ClassTransformerStats classTransformerStats = context.getStats();
            classTransformerStats.setToOnesFound(classTransformerStats.getToOnesFound() + toOneFields.size());
            List<RelationField> toManyFields = this.findRelationFields(context, ctClassEntity, ctClass, "Lio/objectbox/relation/ToMany;", "io.objectbox.relation.ToMany");
            List<RelationField> listToEntityFields = this.findRelationFields(context, ctClassEntity, ctClass, "Ljava/util/List;", "io.objectbox.relation.ToMany");
            Collection collection = toManyFields;
            boolean bl = false;
            CollectionsKt.addAll((Collection)collection, (Iterable)listToEntityFields);
            ClassTransformerStats classTransformerStats2 = context.getStats();
            classTransformerStats2.setToManyFound(classTransformerStats2.getToManyFound() + toManyFields.size());
            if (this.transformConstructors(context, ctClassEntity, ctClass, CollectionsKt.plus((Collection)toOneFields, (Iterable)toManyFields))) {
                changed = true;
            }
        }
        if (changed) {
            if (this.debug) {
                Logging.log((String)("Writing transformed entity \"" + ctClass.getName() + '\"'));
            }
            ctClass.writeFile(entityClass.getOutDir().getAbsolutePath());
        }
        return changed;
    }

    private final boolean checkBoxStoreField(CtClass ctClass, Context context, boolean hasRelations) {
        CtField boxStoreField;
        int n;
        boolean changed;
        block4: {
            CtField ctField;
            changed = false;
            CtField[] ctFieldArray = ctClass.getDeclaredFields();
            Intrinsics.checkExpressionValueIsNotNull((Object)ctFieldArray, (String)"ctClass.declaredFields");
            CtField[] ctFieldArray2 = ctFieldArray;
            n = 0;
            CtField[] ctFieldArray3 = ctFieldArray2;
            boolean bl = false;
            CtField[] ctFieldArray4 = ctFieldArray3;
            int n2 = ctFieldArray4.length;
            for (int i = 0; i < n2; ++i) {
                CtField ctField2;
                CtField it = ctField2 = ctFieldArray4[i];
                boolean bl2 = false;
                CtField ctField3 = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)ctField3, (String)"it");
                if (!Intrinsics.areEqual((Object)ctField3.getName(), (Object)"__boxStore")) continue;
                ctField = ctField2;
                break block4;
            }
            ctField = boxStoreField = null;
        }
        if (boxStoreField != null && Modifier.isPrivate((int)boxStoreField.getModifiers())) {
            boxStoreField.setModifiers(boxStoreField.getModifiers() ^ 2);
            ClassTransformerStats classTransformerStats = context.getStats();
            int n3 = classTransformerStats.getBoxStoreFieldsMadeVisible();
            classTransformerStats.setBoxStoreFieldsMadeVisible(n3 + 1);
            changed = true;
        } else if (boxStoreField == null && hasRelations) {
            String code = "transient io.objectbox.BoxStore __boxStore;";
            boxStoreField = CtField.make((String)code, (CtClass)ctClass);
            ctClass.addField(boxStoreField);
            ClassTransformerStats classTransformerStats = context.getStats();
            n = classTransformerStats.getBoxStoreFieldsAdded();
            classTransformerStats.setBoxStoreFieldsAdded(n + 1);
            changed = true;
        }
        return changed;
    }

    /*
     * WARNING - void declaration
     */
    private final List<RelationField> findRelationFields(Context context, CtClass ctClassEntity, CtClass ctClass, String fieldTypeDescriptor, String relationType) {
        void $this$filterTo$iv$iv;
        boolean bl = false;
        List fields = new ArrayList();
        CtField[] ctFieldArray = ctClass.getDeclaredFields();
        Intrinsics.checkExpressionValueIsNotNull((Object)ctFieldArray, (String)"ctClass.declaredFields");
        CtField[] $this$filter$iv = ctFieldArray;
        boolean $i$f$filter = false;
        CtField[] ctFieldArray2 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        void var12_14 = $this$filterTo$iv$iv;
        int n = ((void)var12_14).length;
        for (int i = 0; i < n; ++i) {
            void element$iv$iv;
            void it = element$iv$iv = var12_14[i];
            boolean bl2 = false;
            void v1 = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)v1, (String)"it");
            FieldInfo fieldInfo = v1.getFieldInfo();
            Intrinsics.checkExpressionValueIsNotNull((Object)fieldInfo, (String)"it.fieldInfo");
            if (!Intrinsics.areEqual((Object)fieldInfo.getDescriptor(), (Object)fieldTypeDescriptor)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            CtField field = (CtField)element$iv;
            boolean bl3 = false;
            CtField ctField = field;
            Intrinsics.checkExpressionValueIsNotNull((Object)ctField, (String)"field");
            FieldInfo fieldInfo = ctField.getFieldInfo();
            Intrinsics.checkExpressionValueIsNotNull((Object)fieldInfo, (String)"field.fieldInfo");
            SignatureAttribute.ClassType targetClassType = JavaAssistExtensionsKt.exGetSingleGenericTypeArgumentOrNull(fieldInfo);
            if (Intrinsics.areEqual((Object)"Ljava/util/List;", (Object)fieldTypeDescriptor)) {
                if (targetClassType == null || !context.getEntityTypes().contains(targetClassType.getName()) || Modifier.isTransient((int)field.getModifiers())) continue;
                FieldInfo fieldInfo2 = field.getFieldInfo();
                Intrinsics.checkExpressionValueIsNotNull((Object)fieldInfo2, (String)"field.fieldInfo");
                if (JavaAssistExtensionsKt.exGetAnnotation(fieldInfo2, ClassConst.INSTANCE.getTransientAnnotationName()) != null) continue;
                FieldInfo fieldInfo3 = field.getFieldInfo();
                Intrinsics.checkExpressionValueIsNotNull((Object)fieldInfo3, (String)"field.fieldInfo");
                if (JavaAssistExtensionsKt.exGetAnnotation(fieldInfo3, ClassConst.INSTANCE.getConvertAnnotationName()) != null) continue;
            }
            String name = this.findRelationNameInEntityInfo(context, ctClassEntity, field, relationType);
            Collection collection = fields;
            RelationField relationField = new RelationField(field, name, relationType, targetClassType);
            boolean bl4 = false;
            collection.add(relationField);
        }
        return fields;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final String findRelationNameInEntityInfo(Context context, CtClass ctClass, CtField field, String relationType) {
        String name;
        block12: {
            String string;
            CtClass entityInfoCtClass;
            String entityInfoClassName;
            block13: {
                boolean bl;
                block10: {
                    CtClass ctClass2;
                    entityInfoClassName = ctClass.getName() + '_';
                    try {
                        ctClass2 = context.getClassPool().get(entityInfoClassName);
                    }
                    catch (NotFoundException e) {
                        throw (Throwable)new TransformException("Could not find generated class \"" + entityInfoClassName + "\", " + "please ensure that ObjectBox class generation runs properly before");
                    }
                    entityInfoCtClass = ctClass2;
                    name = field.getName();
                    CtClass ctClass3 = entityInfoCtClass;
                    Intrinsics.checkExpressionValueIsNotNull((Object)ctClass3, (String)"entityInfoCtClass");
                    CtField[] ctFieldArray = ctClass3.getFields();
                    Intrinsics.checkExpressionValueIsNotNull((Object)ctFieldArray, (String)"entityInfoCtClass.fields");
                    CtField[] $this$any$iv = ctFieldArray;
                    boolean $i$f$any = false;
                    CtField[] ctFieldArray2 = $this$any$iv;
                    int n = ctFieldArray2.length;
                    for (int i = 0; i < n; ++i) {
                        CtField element$iv;
                        CtField it = element$iv = ctFieldArray2[i];
                        boolean bl2 = false;
                        CtField ctField = it;
                        Intrinsics.checkExpressionValueIsNotNull((Object)ctField, (String)"it");
                        if (!Intrinsics.areEqual((Object)ctField.getName(), (Object)name)) continue;
                        bl = true;
                        break block10;
                    }
                    bl = false;
                }
                if (bl) break block12;
                String $i$f$any = relationType;
                switch ($i$f$any.hashCode()) {
                    case 58873154: {
                        if (!$i$f$any.equals("io.objectbox.relation.ToMany")) throw (Throwable)new TransformException("Unexpected " + relationType);
                        break;
                    }
                    case 971732771: {
                        if (!$i$f$any.equals("io.objectbox.relation.ToOne")) throw (Throwable)new TransformException("Unexpected " + relationType);
                        string = "ToOne";
                        break block13;
                    }
                }
                string = "ToMany";
                break block13;
                throw (Throwable)new TransformException("Unexpected " + relationType);
            }
            String suffix = string;
            String string2 = name;
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"name");
            if (StringsKt.endsWith$default((String)string2, (String)suffix, (boolean)false, (int)2, null)) {
                boolean bl;
                String name2;
                block11: {
                    String string3 = name;
                    Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"name");
                    name2 = StringsKt.dropLast((String)string3, (int)suffix.length());
                    CtField[] ctFieldArray = entityInfoCtClass.getFields();
                    Intrinsics.checkExpressionValueIsNotNull((Object)ctFieldArray, (String)"entityInfoCtClass.fields");
                    CtField[] $this$any$iv = ctFieldArray;
                    boolean $i$f$any = false;
                    CtField[] ctFieldArray3 = $this$any$iv;
                    int n = ctFieldArray3.length;
                    for (int i = 0; i < n; ++i) {
                        CtField element$iv;
                        CtField it = element$iv = ctFieldArray3[i];
                        boolean bl3 = false;
                        CtField ctField = it;
                        Intrinsics.checkExpressionValueIsNotNull((Object)ctField, (String)"it");
                        if (!Intrinsics.areEqual((Object)ctField.getName(), (Object)name2)) continue;
                        bl = true;
                        break block11;
                    }
                    bl = false;
                }
                if (!bl) {
                    throw (Throwable)new TransformException("Could not find RelationInfo element for relation field " + '\"' + ctClass.getName() + '.' + name + "\" in generated class \"" + entityInfoClassName + '\"');
                }
                name = name2;
            }
        }
        String string = name;
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"name");
        return string;
    }

    private final boolean transformConstructors(Context context, CtClass ctClassEntity, CtClass ctClass, List<RelationField> relationFields) {
        boolean changed = false;
        for (CtConstructor constructor : ctClass.getConstructors()) {
            if (!constructor.callsSuper()) {
                if (!this.debug) continue;
                StringBuilder stringBuilder = new StringBuilder().append("Skipping constructor ");
                CtConstructor ctConstructor = constructor;
                Intrinsics.checkExpressionValueIsNotNull((Object)ctConstructor, (String)"constructor");
                Logging.log((String)stringBuilder.append(ctConstructor.getLongName()).append(" calling another constructor").toString());
                continue;
            }
            CtConstructor ctConstructor = constructor;
            Intrinsics.checkExpressionValueIsNotNull((Object)ctConstructor, (String)"constructor");
            this.checkMakeParamCtClasses(context, ctConstructor);
            ClassTransformerStats classTransformerStats = context.getStats();
            int n = classTransformerStats.getConstructorsCheckedForTransform();
            classTransformerStats.setConstructorsCheckedForTransform(n + 1);
            HashSet<String> initializedFields = this.getInitializedFields(ctClass, constructor);
            for (RelationField field : relationFields) {
                String fieldName = field.getCtField().getName();
                if (!initializedFields.contains(fieldName)) {
                    int n2;
                    String code = "$0." + fieldName + " = new " + field.getRelationType() + "($0, " + ctClassEntity.getName() + "_#" + field.getRelationName() + ");";
                    try {
                        constructor.insertBeforeBody(code);
                    }
                    catch (Exception e) {
                        throw (Throwable)new TransformException("Could not insert init code for field " + fieldName + " in constructor", e);
                    }
                    if (Intrinsics.areEqual((Object)field.getRelationType(), (Object)"io.objectbox.relation.ToOne")) {
                        ClassTransformerStats classTransformerStats2 = context.getStats();
                        n2 = classTransformerStats2.getToOnesInitializerAdded();
                        classTransformerStats2.setToOnesInitializerAdded(n2 + 1);
                    } else if (Intrinsics.areEqual((Object)field.getRelationType(), (Object)"io.objectbox.relation.ToMany")) {
                        ClassTransformerStats classTransformerStats3 = context.getStats();
                        n2 = classTransformerStats3.getToManyInitializerAdded();
                        classTransformerStats3.setToManyInitializerAdded(n2 + 1);
                    }
                    changed = true;
                    continue;
                }
                Logging.logWarning((String)(ctClass.getName() + " constructor initializes relation field '" + fieldName + "', this might break ObjectBox relations"));
            }
        }
        return changed;
    }

    /*
     * WARNING - void declaration
     */
    private final void checkMakeParamCtClasses(Context context, CtConstructor constructor) {
        try {
            int count = Descriptor.numOfParameters((String)constructor.getSignature());
            int charIndex = 1;
            int n = 0;
            int n2 = count;
            while (n < n2) {
                void i;
                String string = constructor.getSignature();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"constructor.signature");
                Pair<String, Integer> paramPair = this.getParamType(string, charIndex);
                String paramClass = (String)paramPair.getFirst();
                if (paramClass != null && context.getClassPool().getOrNull(paramClass) == null) {
                    context.getClassPool().makeClass(paramClass);
                }
                boolean bl = charIndex != ((Number)paramPair.getSecond()).intValue();
                boolean bl2 = false;
                boolean bl3 = false;
                bl3 = false;
                boolean bl4 = false;
                if (!bl) {
                    boolean bl5 = false;
                    String string2 = "Check failed.";
                    throw (Throwable)new IllegalStateException(string2.toString());
                }
                charIndex = ((Number)paramPair.getSecond()).intValue();
                ++i;
            }
        }
        catch (Exception e) {
            BasicBuildTracker.trackError$default((BasicBuildTracker)new BasicBuildTracker("Transformer"), (String)("Could not define class for params: " + constructor.getSignature()), null, (int)2, null);
        }
        try {
            String lastExMsg = "";
            while (true) {
                try {
                    constructor.getParameterTypes();
                }
                catch (NotFoundException e) {
                    String message = e.getMessage();
                    if (message != null && Intrinsics.areEqual((Object)message, (Object)lastExMsg) ^ true && !StringsKt.contains$default((CharSequence)message, (char)' ', (boolean)false, (int)2, null)) {
                        context.getClassPool().makeClass(message);
                        lastExMsg = message;
                        continue;
                    }
                }
                break;
            }
        }
        catch (Exception e) {
            BasicBuildTracker.trackError$default((BasicBuildTracker)new BasicBuildTracker("Transformer"), (String)("Could not define class for params (2): " + constructor.getSignature()), null, (int)2, null);
        }
    }

    private final Pair<String, Integer> getParamType(String descriptor, int charIndexVal) {
        Pair pair;
        int charIndex = charIndexVal;
        char c = descriptor.charAt(charIndex);
        while (c == '[') {
            c = descriptor.charAt(++charIndex);
        }
        if (c == 'L') {
            int endIndex = StringsKt.indexOf$default((CharSequence)descriptor, (char)';', (int)(++charIndex), (boolean)false, (int)4, null);
            String string = descriptor;
            boolean bl = false;
            String string2 = string;
            if (string2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string3 = string2.substring(charIndex, endIndex);
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            String name = StringsKt.replace$default((String)string3, (char)'/', (char)'.', (boolean)false, (int)4, null);
            pair = new Pair((Object)name, (Object)(endIndex + 1));
        } else {
            pair = new Pair(null, (Object)(charIndex + 1));
        }
        return pair;
    }

    private final HashSet<String> getInitializedFields(CtClass ctClass, CtConstructor constructor) {
        boolean bl = false;
        HashSet<String> initializedFields = new HashSet<String>();
        MethodInfo methodInfo = constructor.getMethodInfo();
        Intrinsics.checkExpressionValueIsNotNull((Object)methodInfo, (String)"constructor.methodInfo");
        CodeIterator codeIterator = methodInfo.getCodeAttribute().iterator();
        codeIterator.begin();
        while (codeIterator.hasNext()) {
            int opIndex = codeIterator.next();
            int op = codeIterator.byteAt(opIndex);
            if (op != 181) continue;
            int fieldIndex = codeIterator.u16bitAt(opIndex + 1);
            ClassFile classFile = ctClass.getClassFile();
            Intrinsics.checkExpressionValueIsNotNull((Object)classFile, (String)"ctClass.classFile");
            ConstPool constPool = classFile.getConstPool();
            String fieldName = constPool.getFieldrefName(fieldIndex);
            if (fieldName == null) continue;
            Collection collection = initializedFields;
            boolean bl2 = false;
            collection.add(fieldName);
        }
        return initializedFields;
    }

    /*
     * WARNING - void declaration
     */
    private final void transformCursors(Context context) {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = context.getProbedClasses();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            ProbedClass it = (ProbedClass)element$iv$iv;
            boolean bl = false;
            if (!it.isCursor()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ProbedClass cursorClass = (ProbedClass)element$iv;
            boolean bl = false;
            CtClass ctClass = this.makeCtClass(context, cursorClass);
            try {
                if (!this.transformCursor(ctClass, cursorClass.getOutDir(), context.getClassPool())) continue;
                context.getTransformedClasses().add(cursorClass);
            }
            catch (Exception e) {
                throw (Throwable)new TransformException("Could not transform Cursor class \"" + ctClass.getName() + "\" (" + e.getMessage() + ')', e);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final boolean transformCursor(CtClass ctClass, File outDir, ClassPool classPool) {
        CtMethod attachCtMethod;
        CtMethod single$iv;
        block9: {
            CtMethod ctMethod;
            CtMethod[] ctMethodArray = ctClass.getDeclaredMethods();
            if (ctMethodArray != null) {
                CtMethod[] $this$singleOrNull$iv = ctMethodArray;
                boolean $i$f$singleOrNull = false;
                single$iv = null;
                boolean found$iv = false;
                CtMethod[] ctMethodArray2 = $this$singleOrNull$iv;
                int n = ctMethodArray2.length;
                for (int i = 0; i < n; ++i) {
                    CtMethod element$iv;
                    CtMethod it = element$iv = ctMethodArray2[i];
                    boolean bl = false;
                    CtMethod ctMethod2 = it;
                    Intrinsics.checkExpressionValueIsNotNull((Object)ctMethod2, (String)"it");
                    if (!Intrinsics.areEqual((Object)ctMethod2.getName(), (Object)"attachEntity")) continue;
                    if (found$iv) {
                        ctMethod = null;
                        break block9;
                    }
                    single$iv = element$iv;
                    found$iv = true;
                }
                ctMethod = !found$iv ? null : single$iv;
            } else {
                ctMethod = attachCtMethod = null;
            }
        }
        if (attachCtMethod != null) {
            void assignsBoxStoreField;
            String signature;
            String string = signature = attachCtMethod.getSignature();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"signature");
            if (!StringsKt.startsWith$default((String)string, (String)"(L", (boolean)false, (int)2, null) || !StringsKt.endsWith$default((String)signature, (String)";)V", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)signature, (char)',', (boolean)false, (int)2, null)) {
                throw (Throwable)new TransformException("Bad signature for " + ctClass.getName() + ".attachEntity: " + signature);
            }
            MethodInfo methodInfo = attachCtMethod.getMethodInfo();
            Intrinsics.checkExpressionValueIsNotNull((Object)methodInfo, (String)"attachCtMethod.methodInfo");
            CodeAttribute codeAttribute = methodInfo.getCodeAttribute();
            Intrinsics.checkExpressionValueIsNotNull((Object)codeAttribute, (String)"attachCtMethod.methodInfo.codeAttribute");
            byte[] existingCode = codeAttribute.getCode();
            if (existingCode.length != 1 || existingCode[0] != (byte)177) {
                Logging.logWarning((String)(ctClass.getName() + ".attachEntity body not empty"));
            }
            single$iv = new Ref.BooleanRef();
            single$iv.element = false;
            attachCtMethod.instrument(new ExprEditor((Ref.BooleanRef)assignsBoxStoreField){
                final /* synthetic */ Ref.BooleanRef $assignsBoxStoreField;

                public void edit(@Nullable FieldAccess f) {
                    FieldAccess fieldAccess = f;
                    if (Intrinsics.areEqual((Object)(fieldAccess != null ? fieldAccess.getFieldName() : null), (Object)"__boxStore") && f.isWriter()) {
                        this.$assignsBoxStoreField.element = true;
                    }
                }
                {
                    this.$assignsBoxStoreField = $captured_local_variable$0;
                }
            });
            if (assignsBoxStoreField.element) {
                Logging.logWarning((String)(ctClass.getName() + ".attachEntity assigns " + "__boxStore, this might break ObjectBox relations"));
                return false;
            }
            this.checkEntityIsInClassPool(classPool, signature);
            String code = "$1.__boxStore = $0.boxStoreForEntities;";
            attachCtMethod.insertAfter(code);
            if (this.debug) {
                Logging.log((String)("Writing transformed cursor '" + ctClass.getName() + '\''));
            }
            ctClass.writeFile(outDir.getAbsolutePath());
            return true;
        }
        return false;
    }

    private final void checkEntityIsInClassPool(ClassPool classPool, String signature) {
        String entityClass = StringsKt.replace$default((String)StringsKt.dropLast((String)StringsKt.drop((String)signature, (int)2), (int)3), (char)'/', (char)'.', (boolean)false, (int)4, null);
        CtClass entityCtClass = null;
        try {
            entityCtClass = classPool.get(entityClass);
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        if (entityCtClass == null) {
            System.out.println("Warning: cursor transformer did not find entity class " + entityClass);
            entityCtClass = classPool.makeClass(entityClass);
            String fieldCode = "transient io.objectbox.BoxStore __boxStore;";
            entityCtClass.addField(CtField.make((String)fieldCode, (CtClass)entityCtClass));
        }
    }

    public final boolean getDebug() {
        return this.debug;
    }

    public ClassTransformer(boolean debug) {
        this.debug = debug;
    }

    public /* synthetic */ ClassTransformer(boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            bl = false;
        }
        this(bl);
    }

    public ClassTransformer() {
        this(false, 1, null);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u000e\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u0004R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001d\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\f0\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0017\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0016\u001a\u00020\u0017\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0017\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00040\u001b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u0013\u00a8\u0006 "}, d2={"Lio/objectbox/gradle/transform/ClassTransformer$Context;", "", "probedClasses", "", "Lio/objectbox/gradle/transform/ProbedClass;", "(Ljava/util/List;)V", "classPool", "Ljavassist/ClassPool;", "getClassPool", "()Ljavassist/ClassPool;", "ctByProbedClass", "", "Ljavassist/CtClass;", "getCtByProbedClass", "()Ljava/util/Map;", "entityTypes", "", "", "getEntityTypes", "()Ljava/util/Set;", "getProbedClasses", "()Ljava/util/List;", "stats", "Lio/objectbox/gradle/transform/ClassTransformerStats;", "getStats", "()Lio/objectbox/gradle/transform/ClassTransformerStats;", "transformedClasses", "", "getTransformedClasses", "wasTransformed", "", "probedClass", "objectbox-gradle-plugin"})
    public static final class Context {
        @NotNull
        private final ClassPool classPool;
        @NotNull
        private final Set<ProbedClass> transformedClasses;
        @NotNull
        private final Map<ProbedClass, CtClass> ctByProbedClass;
        @NotNull
        private final Set<String> entityTypes;
        @NotNull
        private final ClassTransformerStats stats;
        @NotNull
        private final List<ProbedClass> probedClasses;

        @NotNull
        public final ClassPool getClassPool() {
            return this.classPool;
        }

        @NotNull
        public final Set<ProbedClass> getTransformedClasses() {
            return this.transformedClasses;
        }

        @NotNull
        public final Map<ProbedClass, CtClass> getCtByProbedClass() {
            return this.ctByProbedClass;
        }

        @NotNull
        public final Set<String> getEntityTypes() {
            return this.entityTypes;
        }

        @NotNull
        public final ClassTransformerStats getStats() {
            return this.stats;
        }

        public final boolean wasTransformed(@NotNull ProbedClass probedClass) {
            Intrinsics.checkParameterIsNotNull((Object)probedClass, (String)"probedClass");
            return this.transformedClasses.contains(probedClass);
        }

        @NotNull
        public final List<ProbedClass> getProbedClasses() {
            return this.probedClasses;
        }

        /*
         * WARNING - void declaration
         */
        public Context(@NotNull List<ProbedClass> probedClasses) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            ProbedClass it;
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv;
            Intrinsics.checkParameterIsNotNull(probedClasses, (String)"probedClasses");
            this.probedClasses = probedClasses;
            this.classPool = new ClassPool();
            Context context = this;
            boolean bl = false;
            Object object = new LinkedHashSet();
            context.transformedClasses = object;
            context = this;
            bl = false;
            context.ctByProbedClass = object = (Map)new LinkedHashMap();
            Iterable iterable = this.probedClasses;
            context = this;
            boolean $i$f$filter = false;
            void var4_8 = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (ProbedClass)element$iv$iv;
                boolean bl2 = false;
                if (!it.isEntity()) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            object = (List)destination$iv$iv;
            $this$filter$iv = (Iterable)object;
            boolean $i$f$map = false;
            $this$filterTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                it = (ProbedClass)item$iv$iv;
                object = destination$iv$iv;
                boolean bl3 = false;
                String string = it.getName();
                object.add(string);
            }
            object = (List)destination$iv$iv;
            context.entityTypes = CollectionsKt.toHashSet((Iterable)((Iterable)object));
            this.stats = new ClassTransformerStats();
            ProtectionDomain protectionDomain = BoxStoreBuilder.class.getProtectionDomain();
            Intrinsics.checkExpressionValueIsNotNull((Object)protectionDomain, (String)"BoxStoreBuilder::class.java.protectionDomain");
            CodeSource codeSource = protectionDomain.getCodeSource();
            Intrinsics.checkExpressionValueIsNotNull((Object)codeSource, (String)"BoxStoreBuilder::class.j\u2026otectionDomain.codeSource");
            URL uRL = codeSource.getLocation();
            Intrinsics.checkExpressionValueIsNotNull((Object)uRL, (String)"BoxStoreBuilder::class.j\u2026omain.codeSource.location");
            String objectBoxPath = uRL.getPath();
            String decodedObjectBoxPath = URLDecoder.decode(objectBoxPath, "UTF-8");
            this.classPool.appendClassPath(decodedObjectBoxPath);
            this.classPool.appendClassPath((ClassPath)new PrefixedClassPath("java.", Object.class));
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\b\u0002\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0002\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\rR\u0013\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0011"}, d2={"Lio/objectbox/gradle/transform/ClassTransformer$RelationField;", "", "ctField", "Ljavassist/CtField;", "relationName", "", "relationType", "targetTypeSignature", "Ljavassist/bytecode/SignatureAttribute$ClassType;", "(Ljavassist/CtField;Ljava/lang/String;Ljava/lang/String;Ljavassist/bytecode/SignatureAttribute$ClassType;)V", "getCtField", "()Ljavassist/CtField;", "getRelationName", "()Ljava/lang/String;", "getRelationType", "getTargetTypeSignature", "()Ljavassist/bytecode/SignatureAttribute$ClassType;", "objectbox-gradle-plugin"})
    private static final class RelationField {
        @NotNull
        private final CtField ctField;
        @NotNull
        private final String relationName;
        @NotNull
        private final String relationType;
        @Nullable
        private final SignatureAttribute.ClassType targetTypeSignature;

        @NotNull
        public final CtField getCtField() {
            return this.ctField;
        }

        @NotNull
        public final String getRelationName() {
            return this.relationName;
        }

        @NotNull
        public final String getRelationType() {
            return this.relationType;
        }

        @Nullable
        public final SignatureAttribute.ClassType getTargetTypeSignature() {
            return this.targetTypeSignature;
        }

        public RelationField(@NotNull CtField ctField, @NotNull String relationName, @NotNull String relationType, @Nullable SignatureAttribute.ClassType targetTypeSignature) {
            Intrinsics.checkParameterIsNotNull((Object)ctField, (String)"ctField");
            Intrinsics.checkParameterIsNotNull((Object)relationName, (String)"relationName");
            Intrinsics.checkParameterIsNotNull((Object)relationType, (String)"relationType");
            this.ctField = ctField;
            this.relationName = relationName;
            this.relationType = relationType;
            this.targetTypeSignature = targetTypeSignature;
        }
    }
}

