/*
 * Decompiled with CFR 0.152.
 */
package io.objectbox.gradle.transform;

import io.objectbox.gradle.GradleBuildTracker;
import io.objectbox.gradle.transform.ClassProber;
import io.objectbox.gradle.transform.ClassTransformer;
import io.objectbox.gradle.transform.ObjectBoxJavaTransform;
import io.objectbox.gradle.transform.ProbedClass;
import io.objectbox.gradle.transform.TransformException;
import io.objectbox.logging.Logging;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J*\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\t2\b\b\u0002\u0010\u000b\u001a\u00020\u0003R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lio/objectbox/gradle/transform/ObjectBoxJavaTransform;", "", "debug", "", "(Z)V", "transform", "", "byteCodeDirs", "", "Ljava/io/File;", "outDir", "copyNonTransformed", "objectbox-gradle-plugin"})
public final class ObjectBoxJavaTransform {
    private final boolean debug;

    public final void transform(@NotNull List<? extends File> byteCodeDirs, @Nullable File outDir, boolean copyNonTransformed) {
        Intrinsics.checkNotNullParameter(byteCodeDirs, (String)"byteCodeDirs");
        try {
            boolean bl = false;
            List probedClasses = new ArrayList();
            ClassProber classProber = new ClassProber();
            Iterable $this$forEach$iv = byteCodeDirs;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                File byteCodeDir = (File)element$iv;
                boolean bl2 = false;
                if (this.debug) {
                    Logging.log((String)("Detected byte code dir " + byteCodeDir.getPath()));
                }
                Sequence $this$forEach$iv2 = SequencesKt.filter((Sequence)((Sequence)FilesKt.walk$default((File)byteCodeDir, null, (int)1, null)), (Function1)transform.1.1.INSTANCE);
                boolean $i$f$forEach2 = false;
                for (Object element$iv2 : $this$forEach$iv2) {
                    File file = (File)element$iv2;
                    boolean bl3 = false;
                    String string = file.getName();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"file.name");
                    if (!StringsKt.endsWith$default((String)string, (String)".class", (boolean)false, (int)2, null)) continue;
                    Collection collection = probedClasses;
                    File file2 = outDir;
                    if (file2 == null) {
                        file2 = byteCodeDir;
                    }
                    ProbedClass probedClass = classProber.probeClass(file, file2);
                    boolean bl4 = false;
                    collection.add(probedClass);
                }
            }
            new ClassTransformer(this.debug).transformOrCopyClasses(probedClasses, copyNonTransformed);
        }
        catch (Throwable e) {
            GradleBuildTracker buildTracker = new GradleBuildTracker("Transformer");
            if (e instanceof TransformException) {
                buildTracker.trackError("Transform failed", e);
            } else {
                buildTracker.trackFatal("Transform failed", e);
            }
            throw e;
        }
    }

    public static /* synthetic */ void transform$default(ObjectBoxJavaTransform objectBoxJavaTransform, List list, File file, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            file = null;
        }
        if ((n & 4) != 0) {
            bl = true;
        }
        objectBoxJavaTransform.transform(list, file, bl);
    }

    public ObjectBoxJavaTransform(boolean debug) {
        this.debug = debug;
    }
}

