/*
 * Decompiled with CFR 0.152.
 */
package io.objectbox.gradle;

import com.android.build.gradle.AppExtension;
import com.android.build.gradle.AppPlugin;
import com.android.build.gradle.LibraryExtension;
import com.android.build.gradle.LibraryPlugin;
import com.android.build.gradle.api.ApplicationVariant;
import com.android.build.gradle.api.LibraryVariant;
import io.objectbox.gradle.ProjectEnv;
import io.objectbox.reporting.BasicBuildTracker;
import java.util.Iterator;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.gradle.api.DomainObjectSet;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.internal.DefaultDomainObjectSet;
import org.gradle.api.plugins.ExtensionContainer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\u0005\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u000e\u0010\b\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u0007J\n\u0010\t\u001a\u0004\u0018\u00010\u0003H\u0002J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u0007J\n\u0010\f\u001a\u0004\u0018\u00010\u0003H\u0014J*\u0010\r\u001a\u0002H\u000e\"\b\b\u0000\u0010\u000e*\u00020\u000f*\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u0002H\u000e0\u0012H\u0082\u0002\u00a2\u0006\u0002\u0010\u0013\u00a8\u0006\u0014"}, d2={"Lio/objectbox/gradle/GradleBuildTracker;", "Lio/objectbox/reporting/BasicBuildTracker;", "toolName", "", "(Ljava/lang/String;)V", "androidAppId", "env", "Lio/objectbox/gradle/ProjectEnv;", "buildEventProperties", "checkCI", "trackBuild", "", "version", "get", "T", "", "Lorg/gradle/api/plugins/ExtensionContainer;", "type", "Lkotlin/reflect/KClass;", "(Lorg/gradle/api/plugins/ExtensionContainer;Lkotlin/reflect/KClass;)Ljava/lang/Object;", "objectbox-gradle-plugin"})
public class GradleBuildTracker
extends BasicBuildTracker {
    public GradleBuildTracker(@NotNull String toolName) {
        Intrinsics.checkNotNullParameter((Object)toolName, (String)"toolName");
        super(toolName);
    }

    @Nullable
    protected String version() {
        return "3.3.1";
    }

    public final void trackBuild(@NotNull ProjectEnv env) {
        Intrinsics.checkNotNullParameter((Object)env, (String)"env");
        this.countBuild();
        if (this.shouldSendBuildEvent()) {
            BasicBuildTracker.sendEvent$default((BasicBuildTracker)this, (String)"Build", (String)this.buildEventProperties(env), (boolean)false, (int)4, null);
        }
    }

    @NotNull
    public final String buildEventProperties(@NotNull ProjectEnv env) {
        Intrinsics.checkNotNullParameter((Object)env, (String)"env");
        StringBuilder event = new StringBuilder();
        String appId = this.androidAppId(env);
        if (appId != null) {
            this.comma(this.value(this.key(event, "AAID"), this.hashBase64WithoutPadding(appId)));
        }
        StringBuilder stringBuilder = this.key(event, "BuildOS");
        String string = System.getProperty("os.name");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getProperty(\"os.name\")");
        this.comma(this.valueEscaped(stringBuilder, string));
        StringBuilder stringBuilder2 = this.key(event, "BuildOSVersion");
        string = System.getProperty("os.version");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getProperty(\"os.version\")");
        this.comma(this.valueEscaped(stringBuilder2, string));
        this.comma(this.value(this.key(event, "BuildCount"), String.valueOf(this.getAndResetBuildCount())));
        String ci = this.checkCI();
        if (ci != null) {
            this.comma(this.value(this.key(event, "CI"), ci));
        }
        boolean hasKotlinPlugin = env.getHasKotlinAndroidPlugin() || env.getHasKotlinPlugin();
        this.comma(this.value(this.key(event, "Kotlin"), String.valueOf(hasKotlinPlugin)));
        this.comma(this.value(this.key(event, "Java"), String.valueOf(env.getHasJavaPlugin())));
        this.comma(this.value(this.key(event, "Version"), "3.3.1"));
        this.value(this.key(event, "Target"), env.getHasAndroidPlugin() ? "Android" : "Other");
        String string2 = event.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"event.toString()");
        return string2;
    }

    @Nullable
    public String androidAppId(@NotNull ProjectEnv env) {
        Object v1;
        Project project;
        block6: {
            Object v0;
            Object object;
            block5: {
                Intrinsics.checkNotNullParameter((Object)env, (String)"env");
                if (!env.getHasAndroidPlugin()) {
                    return null;
                }
                project = env.getProject();
                Object object2 = project.getPlugins();
                Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"project.plugins");
                object2 = (Iterable)object2;
                boolean bl = false;
                Object object3 = object2;
                boolean bl2 = false;
                Iterator iterator = object3.iterator();
                while (iterator.hasNext()) {
                    object = iterator.next();
                    Plugin it = (Plugin)object;
                    boolean bl3 = false;
                    if (!(it instanceof AppPlugin)) continue;
                    v0 = object;
                    break block5;
                }
                v0 = null;
            }
            Plugin appPlugin = v0;
            if (appPlugin != null) {
                ExtensionContainer extensionContainer = project.getExtensions();
                Intrinsics.checkNotNullExpressionValue((Object)extensionContainer, (String)"project.extensions");
                DomainObjectSet variants = ((AppExtension)this.get(extensionContainer, Reflection.getOrCreateKotlinClass(AppExtension.class))).getApplicationVariants();
                extensionContainer = (ApplicationVariant)CollectionsKt.firstOrNull((Iterable)((Iterable)variants));
                return extensionContainer == null ? null : extensionContainer.getApplicationId();
            }
            Object object4 = project.getPlugins();
            Intrinsics.checkNotNullExpressionValue((Object)object4, (String)"project.plugins");
            object4 = (Iterable)object4;
            boolean bl = false;
            Object object5 = object4;
            boolean bl4 = false;
            object = object5.iterator();
            while (object.hasNext()) {
                Object e = object.next();
                Plugin it = (Plugin)e;
                boolean bl5 = false;
                if (!(it instanceof LibraryPlugin)) continue;
                v1 = e;
                break block6;
            }
            v1 = null;
        }
        Plugin libraryPlugin = v1;
        if (libraryPlugin != null) {
            ExtensionContainer extensionContainer = project.getExtensions();
            Intrinsics.checkNotNullExpressionValue((Object)extensionContainer, (String)"project.extensions");
            DefaultDomainObjectSet variants = ((LibraryExtension)this.get(extensionContainer, Reflection.getOrCreateKotlinClass(LibraryExtension.class))).getLibraryVariants();
            extensionContainer = (LibraryVariant)CollectionsKt.firstOrNull((Iterable)((Iterable)variants));
            return extensionContainer == null ? null : extensionContainer.getApplicationId();
        }
        return null;
    }

    private final String checkCI() {
        String string;
        if (Intrinsics.areEqual((Object)System.getenv("CI"), (Object)"true")) {
            string = "T";
        } else if (System.getenv("JENKINS_URL") != null) {
            string = "J";
        } else if (System.getenv("GITLAB_CI") != null) {
            string = "GL";
        } else if (System.getenv("CIRCLECI") != null) {
            string = "C";
        } else {
            String string2;
            String string3 = System.getenv("CI_NAME");
            if (string3 == null) {
                string2 = null;
            } else {
                String string4 = string3;
                Locale locale = Locale.ROOT;
                Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"ROOT");
                boolean bl = false;
                String string5 = string4.toLowerCase(locale);
                string2 = string5;
                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"(this as java.lang.String).toLowerCase(locale)");
            }
            string = Intrinsics.areEqual(string2, (Object)"codeship") ? "CS" : (System.getenv("CI") != null ? "Other" : null);
        }
        return string;
    }

    private final <T> T get(ExtensionContainer $this$get, KClass<T> type) {
        Intrinsics.checkNotNullParameter((Object)$this$get, (String)"<this>");
        Object object = $this$get.getByType(JvmClassMappingKt.getJavaClass(type));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getByType(type.java)");
        return (T)object;
    }
}

