/*
 * Decompiled with CFR 0.152.
 */
package io.objectbox.gradle;

import io.objectbox.gradle.ProjectEnv;
import io.objectbox.gradle.util.AndroidCompat;
import io.objectbox.reporting.BasicBuildTracker;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Project;
import org.gradle.util.GradleVersion;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\u0005\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u000e\u0010\b\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u0007J\n\u0010\t\u001a\u0004\u0018\u00010\u0003H\u0002J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u0007J\n\u0010\f\u001a\u0004\u0018\u00010\u0003H\u0014\u00a8\u0006\r"}, d2={"Lio/objectbox/gradle/GradleBuildTracker;", "Lio/objectbox/reporting/BasicBuildTracker;", "toolName", "", "(Ljava/lang/String;)V", "androidAppId", "env", "Lio/objectbox/gradle/ProjectEnv;", "buildEventProperties", "checkCI", "trackBuild", "", "version", "objectbox-gradle-plugin"})
public class GradleBuildTracker
extends BasicBuildTracker {
    public GradleBuildTracker(@NotNull String toolName) {
        Intrinsics.checkNotNullParameter((Object)toolName, (String)"toolName");
        super(toolName);
    }

    @Nullable
    protected String version() {
        return "3.8.0";
    }

    public final void trackBuild(@NotNull ProjectEnv env) {
        Intrinsics.checkNotNullParameter((Object)env, (String)"env");
        this.countBuild();
        if (this.shouldSendBuildEvent()) {
            BasicBuildTracker.sendEvent$default((BasicBuildTracker)this, (String)"Build", (String)this.buildEventProperties(env), (boolean)false, (int)4, null);
        }
    }

    @NotNull
    public final String buildEventProperties(@NotNull ProjectEnv env) {
        Intrinsics.checkNotNullParameter((Object)env, (String)"env");
        StringBuilder event = new StringBuilder();
        String appId = this.androidAppId(env);
        if (appId != null) {
            this.comma(this.value(this.key(event, "AAID"), this.hashBase64WithoutPadding(appId)));
        }
        StringBuilder stringBuilder = this.key(event, "BuildOS");
        String string = System.getProperty("os.name");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getProperty(\"os.name\")");
        this.comma(this.valueEscaped(stringBuilder, string));
        StringBuilder stringBuilder2 = this.key(event, "BuildOSVersion");
        String string2 = System.getProperty("os.version");
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getProperty(\"os.version\")");
        this.comma(this.valueEscaped(stringBuilder2, string2));
        this.comma(this.value(this.key(event, "BuildCount"), String.valueOf(this.getAndResetBuildCount())));
        String ci = this.checkCI();
        if (ci != null) {
            this.comma(this.value(this.key(event, "CI"), ci));
        }
        boolean hasKotlinPlugin = env.getHasKotlinAndroidPlugin() || env.getHasKotlinPlugin();
        this.comma(this.value(this.key(event, "Kotlin"), String.valueOf(hasKotlinPlugin)));
        this.comma(this.value(this.key(event, "Java"), String.valueOf(env.getHasJavaPlugin())));
        this.comma(this.value(this.key(event, "Version"), "3.8.0"));
        this.comma(this.value(this.key(event, "Target"), env.getHasAndroidPlugin() ? "Android" : "Other"));
        if (env.getHasAndroidPlugin()) {
            this.comma(this.value(this.key(event, "AGP"), AndroidCompat.INSTANCE.getPluginVersion(env.getProject())));
        }
        StringBuilder stringBuilder3 = this.key(event, "Gradle");
        String string3 = GradleVersion.current().getVersion();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"current().version");
        this.value(stringBuilder3, string3);
        String string4 = event.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"event.toString()");
        return string4;
    }

    @Nullable
    public String androidAppId(@NotNull ProjectEnv env) {
        Intrinsics.checkNotNullParameter((Object)env, (String)"env");
        if (!env.getHasAndroidPlugin()) {
            return null;
        }
        Project project = env.getProject();
        return AndroidCompat.INSTANCE.getPlugin(project).getFirstApplicationId(project);
    }

    private final String checkCI() {
        String string;
        if (System.getenv("GITHUB_ACTIONS") != null) {
            string = "GH";
        } else if (System.getenv("TRAVIS") != null) {
            string = "T";
        } else if (System.getenv("JENKINS_URL") != null) {
            string = "J";
        } else if (System.getenv("GITLAB_CI") != null) {
            string = "GL";
        } else if (System.getenv("CIRCLECI") != null) {
            string = "C";
        } else {
            String string2;
            String string3 = System.getenv("CI_NAME");
            if (string3 != null) {
                String string4 = string3;
                Locale locale = Locale.ROOT;
                Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"ROOT");
                String string5 = string4.toLowerCase(locale);
                string2 = string5;
                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"this as java.lang.String).toLowerCase(locale)");
            } else {
                string2 = null;
            }
            string = Intrinsics.areEqual(string2, (Object)"codeship") ? "CS" : (Intrinsics.areEqual((Object)System.getenv("CI"), (Object)"true") ? "Other" : null);
        }
        return string;
    }
}

